/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.nbt;

import buildcraft.api.core.InvalidInputDataException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public enum WrittenType {
    BYTE(1, 255),
    SHORT(2, 65535),
    MEDIUM(3, 0xFFFFFF),
    INT(4, Integer.MAX_VALUE);

    public static final WrittenType[] ORDERED_VALUES;
    public final int numBytes;
    private final int maxStorableValue;

    private WrittenType(int numBytes, int maxStorableValue) {
        this.maxStorableValue = maxStorableValue;
        this.numBytes = numBytes;
    }

    public static WrittenType getForSize(int size) {
        for (WrittenType type : ORDERED_VALUES) {
            if (size >= type.maxStorableValue) continue;
            return type;
        }
        throw new IllegalArgumentException("Waaaaay too big index list (" + size + ")");
    }

    public void writeType(DataOutput to) throws IOException {
        to.writeByte(this.numBytes - 1);
    }

    public static WrittenType readType(DataInput in) throws IOException {
        byte val = in.readByte();
        for (WrittenType type : ORDERED_VALUES) {
            if (val != type.numBytes - 1) continue;
            return type;
        }
        throw new InvalidInputDataException("Incorrect size given, expected any of [0, 1, 2, 3] but got " + val);
    }

    public void writeIndex(DataOutput out, int index) throws IOException {
        if (index > this.maxStorableValue) {
            throw new IllegalArgumentException("Tried to write a value that was too large! (" + index + " > " + this.maxStorableValue + " for " + (Object)((Object)this) + ")");
        }
        switch (this) {
            case BYTE: {
                out.writeByte(index);
                break;
            }
            case SHORT: {
                out.writeShort(index);
                break;
            }
            case MEDIUM: {
                out.writeByte(index & 0xFF);
                out.writeShort(index >> 8);
                break;
            }
            default: {
                out.writeInt(index);
            }
        }
    }

    public int readIndex(DataInput in) throws IOException {
        switch (this) {
            case BYTE: {
                return in.readUnsignedByte();
            }
            case SHORT: {
                return in.readUnsignedShort();
            }
            case MEDIUM: {
                int val = in.readUnsignedByte();
                return val |= in.readUnsignedShort() << 8;
            }
        }
        return in.readInt();
    }

    static {
        ORDERED_VALUES = new WrittenType[]{BYTE, SHORT, MEDIUM, INT};
    }
}

