/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc.data;

import buildcraft.lib.misc.data.EnumAxisOrder;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class AxisOrder {
    private static final Table<EnumAxisOrder, Inversion, AxisOrder> allOrders;
    public final EnumAxisOrder order;
    public final Inversion inversion;
    public final EnumFacing first;
    public final EnumFacing second;
    public final EnumFacing third;

    private AxisOrder(EnumAxisOrder order, Inversion inv) {
        this.order = order;
        this.inversion = inv;
        this.first = EnumFacing.func_181076_a((EnumFacing.AxisDirection)inv.first, (EnumFacing.Axis)order.first);
        this.second = EnumFacing.func_181076_a((EnumFacing.AxisDirection)inv.second, (EnumFacing.Axis)order.second);
        this.third = EnumFacing.func_181076_a((EnumFacing.AxisDirection)inv.third, (EnumFacing.Axis)order.third);
    }

    public static AxisOrder readNbt(NBTTagCompound nbt) {
        return AxisOrder.getFor(EnumAxisOrder.getOrder(nbt.func_74779_i("order")), Inversion.getFor(nbt.func_74779_i("inversion")));
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("order", this.order.name());
        nbt.func_74778_a("inversion", this.inversion.name());
        return nbt;
    }

    public static AxisOrder getFor(EnumAxisOrder order, Inversion inv) {
        if (order == null) {
            throw new NullPointerException("order");
        }
        if (inv == null) {
            throw new NullPointerException("inv");
        }
        AxisOrder axisOrder = (AxisOrder)allOrders.get((Object)order, (Object)inv);
        if (axisOrder == null) {
            throw new IllegalStateException("Tried to lookup " + (Object)((Object)order) + ", " + (Object)((Object)inv) + " but failed!");
        }
        return axisOrder;
    }

    public String toString() {
        return this.first + ", " + this.second + ", " + this.third;
    }

    public AxisOrder invertFirst() {
        return (AxisOrder)allOrders.get((Object)this.order, (Object)Inversion.getFor(this.first.func_176734_d(), this.second, this.third));
    }

    public AxisOrder invertSecond() {
        return (AxisOrder)allOrders.get((Object)this.order, (Object)Inversion.getFor(this.first, this.second.func_176734_d(), this.third));
    }

    public AxisOrder invertThird() {
        return (AxisOrder)allOrders.get((Object)this.order, (Object)Inversion.getFor(this.first, this.second, this.third.func_176734_d()));
    }

    public AxisOrder invert(EnumFacing.Axis axis) {
        if (axis == this.first.func_176740_k()) {
            return this.invertFirst();
        }
        if (axis == this.second.func_176740_k()) {
            return this.invertSecond();
        }
        return this.invertThird();
    }

    static {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (EnumAxisOrder order : EnumAxisOrder.VALUES) {
            for (Inversion inv : Inversion.VALUES) {
                builder.put((Object)order, (Object)inv, (Object)new AxisOrder(order, inv));
            }
        }
        allOrders = builder.build();
    }

    public static enum Inversion {
        PPP,
        PPN,
        PNP,
        PNN,
        NPP,
        NPN,
        NNP,
        NNN;

        public static final Inversion[] VALUES;
        public final EnumFacing.AxisDirection first = Inversion.getFor(this.name().charAt(0));
        public final EnumFacing.AxisDirection second = Inversion.getFor(this.name().charAt(1));
        public final EnumFacing.AxisDirection third = Inversion.getFor(this.name().charAt(2));

        private static EnumFacing.AxisDirection getFor(char charAt) {
            if (charAt == 'P') {
                return EnumFacing.AxisDirection.POSITIVE;
            }
            if (charAt == 'N') {
                return EnumFacing.AxisDirection.NEGATIVE;
            }
            throw new Error("Unknown char " + charAt);
        }

        public static Inversion getFor(EnumFacing first, EnumFacing second, EnumFacing third) {
            return Inversion.getFor(first.func_176743_c(), second.func_176743_c(), third.func_176743_c());
        }

        public static Inversion getFor(EnumFacing.AxisDirection first, EnumFacing.AxisDirection second, EnumFacing.AxisDirection third) {
            return Inversion.getFor(first == EnumFacing.AxisDirection.POSITIVE, second == EnumFacing.AxisDirection.POSITIVE, third == EnumFacing.AxisDirection.POSITIVE);
        }

        public static Inversion getFor(boolean first, boolean second, boolean third) {
            if (first) {
                if (second) {
                    return third ? PPP : PPN;
                }
                return third ? PNP : PNN;
            }
            if (second) {
                return third ? NPP : NPN;
            }
            return third ? NNP : NNN;
        }

        public static Inversion getFor(String name) {
            if (name == null || name.length() != 3) {
                return PPP;
            }
            boolean first = name.charAt(0) == 'P';
            boolean second = name.charAt(1) == 'P';
            boolean third = name.charAt(2) == 'P';
            return Inversion.getFor(first, second, third);
        }

        static {
            VALUES = Inversion.values();
        }
    }
}

