/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.json;

import buildcraft.api.core.render.ISprite;
import buildcraft.lib.client.sprite.SpriteRaw;
import buildcraft.lib.client.sprite.SubSpriteChanging;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.gui.GuiSpriteScaled;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.elem.GuiElementDrawable;
import buildcraft.lib.gui.json.BuildCraftJsonGui;
import buildcraft.lib.gui.json.ElementType;
import buildcraft.lib.gui.json.JsonGuiElement;
import buildcraft.lib.gui.json.JsonGuiInfo;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.gui.pos.PositionAbsolute;
import buildcraft.lib.misc.GuiUtil;
import buildcraft.lib.misc.SpriteUtil;
import net.minecraft.util.ResourceLocation;

public class ElementTypeSprite
extends ElementType {
    public static final String NAME = "buildcraftlib:drawable";
    public static final ElementTypeSprite INSTANCE = new ElementTypeSprite();

    private ElementTypeSprite() {
        super(NAME);
    }

    @Override
    public IGuiElement deserialize0(BuildCraftJsonGui gui, IGuiPosition parent, JsonGuiInfo info, JsonGuiElement json) {
        ISprite sprite;
        FunctionContext ctx = ElementTypeSprite.createContext(json);
        ElementTypeSprite.inheritProperty(json, "pos[0]", "area[0]");
        ElementTypeSprite.inheritProperty(json, "pos[1]", "area[1]");
        ElementTypeSprite.inheritProperty(json, "size[0]", "area[2]");
        ElementTypeSprite.inheritProperty(json, "size[1]", "area[3]");
        ElementTypeSprite.inheritProperty(json, "source.pos[0]", "source.area[0]");
        ElementTypeSprite.inheritProperty(json, "source.pos[1]", "source.area[1]");
        ElementTypeSprite.inheritProperty(json, "source.size[0]", "source.area[2]");
        ElementTypeSprite.inheritProperty(json, "source.size[1]", "source.area[3]");
        ElementTypeSprite.inheritProperty(json, "area", "source.area");
        ElementTypeSprite.inheritProperty(json, "area[0]", "source.area[0]");
        ElementTypeSprite.inheritProperty(json, "area[1]", "source.area[1]");
        ElementTypeSprite.inheritProperty(json, "area[2]", "source.area[2]");
        ElementTypeSprite.inheritProperty(json, "area[3]", "source.area[3]");
        IGuiArea area = ElementTypeSprite.resolveArea(json, "area", parent, ctx);
        IGuiArea srcArea = ElementTypeSprite.resolveArea(json, "source.area", PositionAbsolute.ORIGIN, ctx);
        IExpressionNode.INodeBoolean visible = ElementTypeSprite.getEquationBool(json, "visible", ctx, true);
        boolean foreground = ElementTypeSprite.resolveEquationBool(json, "foreground", ctx, false);
        ElementType.SrcTexture tex = ElementTypeSprite.resolveTexture(info, json, "source");
        String origin = tex.origin;
        int texSize = tex.texSize;
        if (!(json.properties.containsKey("source.area[2]") || json.properties.containsKey("source.area[3]") || json.properties.containsKey("source.area"))) {
            srcArea = new GuiRectangle(texSize, texSize);
        }
        if ((sprite = gui.properties.get(origin, ISprite.class)) == null) {
            ResourceLocation loc = SpriteUtil.transformLocation(new ResourceLocation(origin));
            sprite = new SpriteRaw(loc, 0.0, 0.0, 1.0, 1.0);
        }
        if (srcArea instanceof GuiRectangle) {
            double u = srcArea.getX();
            double v = srcArea.getY();
            double uSize = srcArea.getWidth();
            double vSize = srcArea.getHeight();
            sprite = GuiUtil.subRelative(sprite, u, v, uSize, vSize, texSize);
        } else {
            IGuiArea a = srcArea;
            IExpressionNode.INodeDouble u = () -> a.getX() / (double)texSize;
            IExpressionNode.INodeDouble v = () -> a.getY() / (double)texSize;
            IExpressionNode.INodeDouble uSize = () -> a.getEndX() / (double)texSize;
            IExpressionNode.INodeDouble vSize = () -> a.getEndY() / (double)texSize;
            sprite = new SubSpriteChanging(sprite, u, v, uSize, vSize);
        }
        GuiSpriteScaled icon = new GuiSpriteScaled(sprite, area.offsetToOrigin());
        GuiElementDrawable element = new GuiElementDrawable(gui, area, icon, foreground, visible);
        return element;
    }
}

