/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.elem;

import buildcraft.lib.gui.BuildCraftGui;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.elem.GuiElementContainer2;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.pos.IGuiPosition;
import java.util.List;

public class GuiElementContainerResizing
extends GuiElementContainer2 {
    public final IGuiPosition childRoot;
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;

    public GuiElementContainerResizing(BuildCraftGui gui, IGuiPosition childRoot) {
        super(gui);
        this.childRoot = childRoot;
        this.minX = this.maxX = childRoot.getX();
        this.minY = this.maxY = childRoot.getY();
    }

    @Override
    public IGuiPosition getChildElementPosition() {
        return this.childRoot;
    }

    @Override
    public double getX() {
        return this.childRoot.getX() + this.minX;
    }

    @Override
    public double getY() {
        return this.childRoot.getY() + this.minY;
    }

    @Override
    public double getWidth() {
        return this.maxX - this.minX;
    }

    @Override
    public double getHeight() {
        return this.maxY - this.minY;
    }

    @Override
    public void calculateSizes() {
        double y1;
        double x1;
        this.minY = 0.0;
        this.maxY = 0.0;
        this.minX = 0.0;
        this.maxX = 0.0;
        double x = this.childRoot.getX();
        double y = this.childRoot.getY();
        double x0 = x1 = x;
        double y0 = y1 = y;
        for (IGuiElement elem : this.getChildElements()) {
            x0 = Math.min(x0, elem.getX());
            y0 = Math.min(y0, elem.getY());
            x1 = Math.max(x1, elem.getEndX());
            y1 = Math.max(y1, elem.getEndY());
        }
        this.minX = x0 - x;
        this.maxX = x1 - x;
        this.minY = y0 - y;
        this.maxY = y1 - y;
    }

    @Override
    public void drawBackground(float partialTicks) {
        for (IGuiElement elem : this.getChildElements()) {
            elem.drawBackground(partialTicks);
        }
    }

    @Override
    public void drawForeground(float partialTicks) {
        for (IGuiElement elem : this.getChildElements()) {
            elem.drawForeground(partialTicks);
        }
    }

    @Override
    public void addToolTips(List<ToolTip> tooltips) {
        super.addToolTips(tooltips);
    }
}

