/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.button;

import buildcraft.lib.gui.BuildCraftGui;
import buildcraft.lib.gui.GuiElementSimple;
import buildcraft.lib.gui.IInteractionElement;
import buildcraft.lib.gui.button.IButtonBehaviour;
import buildcraft.lib.gui.button.IButtonClickEventListener;
import buildcraft.lib.gui.button.IButtonClickEventTrigger;
import buildcraft.lib.gui.elem.GuiElementText;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import net.minecraft.client.gui.FontRenderer;

public abstract class GuiAbstractButton
extends GuiElementSimple
implements IButtonClickEventTrigger,
IInteractionElement {
    private final List<IButtonClickEventListener> listeners = new ArrayList<IButtonClickEventListener>();
    public final String id;
    public boolean active;
    public boolean enabled = true;
    public boolean visible = true;
    private IButtonBehaviour behaviour = IButtonBehaviour.DEFAULT;
    private ToolTip toolTip;

    public GuiAbstractButton(BuildCraftGui gui, String id, IGuiArea area) {
        super(gui, area);
        this.id = id;
    }

    public GuiElementText createTextElement(String text) {
        return this.createTextElement(() -> text);
    }

    public GuiElementText createTextElement(Supplier<String> text) {
        FontRenderer fr = this.gui.mc.field_71466_p;
        DoubleSupplier x = () -> -fr.func_78256_a((String)text.get()) / 2;
        DoubleSupplier y = () -> -fr.field_78288_b / 2;
        IGuiPosition pos = this.getCenter().offset(x, y);
        return new GuiElementText(this.gui, pos, text, this::getColourForText);
    }

    public int getColourForText() {
        if (!this.enabled) {
            return 0xA0A0A0;
        }
        if (this.isMouseOver()) {
            return 0xFFFFA0;
        }
        return 0xE0E0E0;
    }

    public boolean isActive() {
        return this.active;
    }

    public final void activate() {
        this.setActive(true);
    }

    public final void deActivate() {
        this.setActive(false);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isMouseOver() {
        return this.contains(this.gui.mouse);
    }

    protected int getHoverState(boolean mouseOver) {
        if (!this.enabled) {
            return 0;
        }
        return mouseOver ? (this.active ? 2 : 4) : (this.active ? 1 : 3);
    }

    public void setBehaviour(IButtonBehaviour behaviour) {
        this.behaviour = behaviour;
    }

    public void setToolTip(ToolTip tips) {
        this.toolTip = tips;
    }

    @Override
    public void addToolTips(List<ToolTip> tooltips) {
        if (this.visible && this.toolTip != null && this.isMouseOver()) {
            tooltips.add(this.toolTip);
        }
    }

    @Override
    public void notifyButtonClicked(int bkey) {
        for (IButtonClickEventListener listener : this.listeners) {
            listener.handleButtonClick(this, bkey);
        }
    }

    @Override
    public void registerListener(IButtonClickEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IButtonClickEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean isButtonActive() {
        return this.active;
    }

    @Override
    public void onMouseClicked(int button) {
        if (this.contains(this.gui.mouse)) {
            this.behaviour.mousePressed(this, button);
        }
    }

    @Override
    public void onMouseReleased(int button) {
        this.behaviour.mouseReleased(this, button);
    }
}

