/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IDependancyVisitor;
import buildcraft.lib.expression.api.IDependantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionBi;
import buildcraft.lib.expression.node.value.NodeConstantBoolean;
import java.util.Objects;

public class NodeFuncObjectToBoolean<A>
extends NodeFuncBase
implements INodeFunc.INodeFuncBoolean {
    public final IFuncObjectToBoolean<A> function;
    private final StringFunctionBi stringFunction;
    private final Class<A> argTypeA;

    public NodeFuncObjectToBoolean(String name, Class<A> argTypeA, IFuncObjectToBoolean<A> function) {
        this(argTypeA, function, (String a) -> "[ " + NodeTypes.getName(argTypeA) + " -> boolean ] " + name + "(" + a + ")");
    }

    public NodeFuncObjectToBoolean(Class<A> argTypeA, IFuncObjectToBoolean<A> function, StringFunctionBi stringFunction) {
        this.argTypeA = argTypeA;
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}");
    }

    @Override
    public NodeFuncObjectToBoolean<A> setNeverInline() {
        super.setNeverInline();
        return this;
    }

    @Override
    public IExpressionNode.INodeBoolean getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeObject<A> a = stack.popObject(this.argTypeA);
        return this.create(a);
    }

    public FuncObjectToBoolean create(IExpressionNode.INodeObject<A> argA) {
        return new FuncObjectToBoolean(argA);
    }

    @FunctionalInterface
    public static interface IFuncObjectToBoolean<A> {
        public boolean apply(A var1);
    }

    public class FuncObjectToBoolean
    implements IExpressionNode.INodeBoolean,
    IDependantNode,
    NodeFuncBase.IFunctionNode {
        public final IExpressionNode.INodeObject<A> argA;

        public FuncObjectToBoolean(IExpressionNode.INodeObject<A> argA) {
            this.argA = argA;
        }

        @Override
        public boolean evaluate() {
            return NodeFuncObjectToBoolean.this.function.apply(this.argA.evaluate());
        }

        @Override
        public IExpressionNode.INodeBoolean inline() {
            if (!NodeFuncObjectToBoolean.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, a -> new FuncObjectToBoolean(a), a -> new FuncObjectToBoolean(a));
            }
            return NodeInliningHelper.tryInline(this, this.argA, a -> new FuncObjectToBoolean(a), a -> NodeConstantBoolean.of(NodeFuncObjectToBoolean.this.function.apply(a.evaluate())));
        }

        @Override
        public void visitDependants(IDependancyVisitor visitor) {
            if (!NodeFuncObjectToBoolean.this.canInline) {
                if (NodeFuncObjectToBoolean.this.function instanceof IDependantNode) {
                    visitor.dependOn((IDependantNode)((Object)NodeFuncObjectToBoolean.this.function));
                } else {
                    visitor.dependOnExplictly(this);
                }
            }
            visitor.dependOn((IExpressionNode)this.argA);
        }

        public String toString() {
            return NodeFuncObjectToBoolean.this.stringFunction.apply(this.argA.toString());
        }

        @Override
        public NodeFuncBase getFunction() {
            return NodeFuncObjectToBoolean.this;
        }

        public int hashCode() {
            return Objects.hash(this.argA);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FuncObjectToBoolean other = (FuncObjectToBoolean)obj;
            return Objects.equals(this.argA, other.argA);
        }
    }
}

