/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IDependancyVisitor;
import buildcraft.lib.expression.api.IDependantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionTri;
import buildcraft.lib.expression.node.value.NodeConstantObject;
import java.util.Objects;

public class NodeFuncObjectBooleanToObject<A, R>
extends NodeFuncBase
implements INodeFunc.INodeFuncObject<R> {
    public final IFuncObjectBooleanToObject<A, R> function;
    private final StringFunctionTri stringFunction;
    private final Class<A> argTypeA;
    private final Class<R> returnType;

    public NodeFuncObjectBooleanToObject(String name, Class<A> argTypeA, Class<R> returnType, IFuncObjectBooleanToObject<A, R> function) {
        this(argTypeA, returnType, function, (String a, String b) -> "[ " + NodeTypes.getName(argTypeA) + ", boolean -> " + NodeTypes.getName(returnType) + " ] " + name + "(" + a + ", " + b + ")");
    }

    public NodeFuncObjectBooleanToObject(Class<A> argTypeA, Class<R> returnType, IFuncObjectBooleanToObject<A, R> function, StringFunctionTri stringFunction) {
        this.argTypeA = argTypeA;
        this.returnType = returnType;
        this.function = function;
        this.stringFunction = stringFunction;
    }

    @Override
    public Class<R> getType() {
        return this.returnType;
    }

    public String toString() {
        return this.stringFunction.apply("{A}", "{B}");
    }

    @Override
    public NodeFuncObjectBooleanToObject<A, R> setNeverInline() {
        super.setNeverInline();
        return this;
    }

    @Override
    public IExpressionNode.INodeObject<R> getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeBoolean b = stack.popBoolean();
        IExpressionNode.INodeObject<A> a = stack.popObject(this.argTypeA);
        return this.create(a, b);
    }

    public FuncObjectBooleanToObject create(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeBoolean argB) {
        return new FuncObjectBooleanToObject(argA, argB);
    }

    @FunctionalInterface
    public static interface IFuncObjectBooleanToObject<A, R> {
        public R apply(A var1, boolean var2);
    }

    public class FuncObjectBooleanToObject
    implements IExpressionNode.INodeObject<R>,
    IDependantNode,
    NodeFuncBase.IFunctionNode {
        public final IExpressionNode.INodeObject<A> argA;
        public final IExpressionNode.INodeBoolean argB;

        public FuncObjectBooleanToObject(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeBoolean argB) {
            this.argA = argA;
            this.argB = argB;
        }

        @Override
        public Class<R> getType() {
            return NodeFuncObjectBooleanToObject.this.returnType;
        }

        @Override
        public R evaluate() {
            return NodeFuncObjectBooleanToObject.this.function.apply(this.argA.evaluate(), this.argB.evaluate());
        }

        @Override
        public IExpressionNode.INodeObject<R> inline() {
            if (!NodeFuncObjectBooleanToObject.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new FuncObjectBooleanToObject(a, (IExpressionNode.INodeBoolean)b), (a, b) -> new FuncObjectBooleanToObject(a, (IExpressionNode.INodeBoolean)b));
            }
            return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new FuncObjectBooleanToObject(a, (IExpressionNode.INodeBoolean)b), (a, b) -> new NodeConstantObject(NodeFuncObjectBooleanToObject.this.returnType, NodeFuncObjectBooleanToObject.this.function.apply(a.evaluate(), b.evaluate())));
        }

        @Override
        public void visitDependants(IDependancyVisitor visitor) {
            if (!NodeFuncObjectBooleanToObject.this.canInline) {
                if (NodeFuncObjectBooleanToObject.this.function instanceof IDependantNode) {
                    visitor.dependOn((IDependantNode)((Object)NodeFuncObjectBooleanToObject.this.function));
                } else {
                    visitor.dependOnExplictly(this);
                }
            }
            visitor.dependOn(this.argA, this.argB);
        }

        public String toString() {
            return NodeFuncObjectBooleanToObject.this.stringFunction.apply(this.argA.toString(), this.argB.toString());
        }

        @Override
        public NodeFuncBase getFunction() {
            return NodeFuncObjectBooleanToObject.this;
        }

        public int hashCode() {
            return Objects.hash(this.argA, this.argB);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FuncObjectBooleanToObject other = (FuncObjectBooleanToObject)obj;
            return Objects.equals(this.argA, other.argA) && Objects.equals(this.argB, other.argB);
        }
    }
}

