/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IDependancyVisitor;
import buildcraft.lib.expression.api.IDependantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionBi;
import buildcraft.lib.expression.node.value.NodeConstantObject;
import java.util.Objects;

public class NodeFuncDoubleToObject<R>
extends NodeFuncBase
implements INodeFunc.INodeFuncObject<R> {
    public final IFuncDoubleToObject<R> function;
    private final StringFunctionBi stringFunction;
    private final Class<R> returnType;

    public NodeFuncDoubleToObject(String name, Class<R> returnType, IFuncDoubleToObject<R> function) {
        this(returnType, function, (String a) -> "[ double -> " + NodeTypes.getName(returnType) + " ] " + name + "(" + a + ")");
    }

    public NodeFuncDoubleToObject(Class<R> returnType, IFuncDoubleToObject<R> function, StringFunctionBi stringFunction) {
        this.returnType = returnType;
        this.function = function;
        this.stringFunction = stringFunction;
    }

    @Override
    public Class<R> getType() {
        return this.returnType;
    }

    public String toString() {
        return this.stringFunction.apply("{A}");
    }

    @Override
    public NodeFuncDoubleToObject<R> setNeverInline() {
        super.setNeverInline();
        return this;
    }

    @Override
    public IExpressionNode.INodeObject<R> getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeDouble a = stack.popDouble();
        return this.create(a);
    }

    public FuncDoubleToObject create(IExpressionNode.INodeDouble argA) {
        return new FuncDoubleToObject(argA);
    }

    @FunctionalInterface
    public static interface IFuncDoubleToObject<R> {
        public R apply(double var1);
    }

    public class FuncDoubleToObject
    implements IExpressionNode.INodeObject<R>,
    IDependantNode,
    NodeFuncBase.IFunctionNode {
        public final IExpressionNode.INodeDouble argA;

        public FuncDoubleToObject(IExpressionNode.INodeDouble argA) {
            this.argA = argA;
        }

        @Override
        public Class<R> getType() {
            return NodeFuncDoubleToObject.this.returnType;
        }

        @Override
        public R evaluate() {
            return NodeFuncDoubleToObject.this.function.apply(this.argA.evaluate());
        }

        @Override
        public IExpressionNode.INodeObject<R> inline() {
            if (!NodeFuncDoubleToObject.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, a -> new FuncDoubleToObject((IExpressionNode.INodeDouble)a), a -> new FuncDoubleToObject((IExpressionNode.INodeDouble)a));
            }
            return NodeInliningHelper.tryInline(this, this.argA, a -> new FuncDoubleToObject((IExpressionNode.INodeDouble)a), a -> new NodeConstantObject(NodeFuncDoubleToObject.this.returnType, NodeFuncDoubleToObject.this.function.apply(a.evaluate())));
        }

        @Override
        public void visitDependants(IDependancyVisitor visitor) {
            if (!NodeFuncDoubleToObject.this.canInline) {
                if (NodeFuncDoubleToObject.this.function instanceof IDependantNode) {
                    visitor.dependOn((IDependantNode)((Object)NodeFuncDoubleToObject.this.function));
                } else {
                    visitor.dependOnExplictly(this);
                }
            }
            visitor.dependOn((IExpressionNode)this.argA);
        }

        public String toString() {
            return NodeFuncDoubleToObject.this.stringFunction.apply(this.argA.toString());
        }

        @Override
        public NodeFuncBase getFunction() {
            return NodeFuncDoubleToObject.this;
        }

        public int hashCode() {
            return Objects.hash(this.argA);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FuncDoubleToObject other = (FuncDoubleToObject)obj;
            return Objects.equals(this.argA, other.argA);
        }
    }
}

