/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.sprite;

import buildcraft.api.core.render.ISprite;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.gui.pos.IGuiArea;

public class SubSpriteChanging
implements ISprite {
    private final ISprite delegate;
    private final IExpressionNode.INodeDouble uMin;
    private final IExpressionNode.INodeDouble vMin;
    private final IExpressionNode.INodeDouble uMax;
    private final IExpressionNode.INodeDouble vMax;

    public SubSpriteChanging(ISprite delegate, IExpressionNode.INodeDouble uMin, IExpressionNode.INodeDouble vMin, IExpressionNode.INodeDouble uMax, IExpressionNode.INodeDouble vMax) {
        this.delegate = delegate;
        this.uMin = uMin;
        this.vMin = vMin;
        this.uMax = uMax;
        this.vMax = vMax;
    }

    public SubSpriteChanging(ISprite delegate, IGuiArea area) {
        this(delegate, area::getX, area::getY, area::getEndX, area::getEndY);
    }

    @Override
    public void bindTexture() {
        this.delegate.bindTexture();
    }

    @Override
    public double getInterpU(double u) {
        double iu = this.uMin.evaluate() * (1.0 - u) + this.uMax.evaluate() * u;
        return this.delegate.getInterpU(iu);
    }

    @Override
    public double getInterpV(double v) {
        double iv = this.vMin.evaluate() * (1.0 - v) + this.vMax.evaluate() * v;
        return this.delegate.getInterpV(iv);
    }
}

