/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.render.laser;

import buildcraft.api.core.render.ISprite;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import java.util.Objects;
import net.minecraft.util.math.Vec3d;

public class LaserData_BC8 {
    public final LaserType laserType;
    public final Vec3d start;
    public final Vec3d end;
    public final double scale;
    public final boolean enableDiffuse;
    public final boolean doubleFace;
    public final int minBlockLight;
    private final int hash;

    public LaserData_BC8(LaserType laserType, Vec3d start, Vec3d end, double scale) {
        this(laserType, start, end, scale, true, false, 0);
    }

    public LaserData_BC8(LaserType laserType, Vec3d start, Vec3d end, double scale, boolean enableDiffuse, boolean doubleFace, int minBlockLight) {
        this.laserType = laserType;
        this.start = start;
        this.end = end;
        this.scale = scale;
        this.enableDiffuse = enableDiffuse;
        this.doubleFace = doubleFace;
        this.minBlockLight = minBlockLight;
        this.hash = Objects.hash(laserType, start, end, Double.doubleToLongBits(scale), enableDiffuse, doubleFace, minBlockLight);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        LaserData_BC8 other = (LaserData_BC8)obj;
        if (this.laserType != other.laserType) {
            return false;
        }
        if (!this.start.equals((Object)other.start)) {
            return false;
        }
        if (!this.end.equals((Object)other.end)) {
            return false;
        }
        if (Double.compare(this.scale, other.scale) != 0) {
            return false;
        }
        if (this.enableDiffuse != other.enableDiffuse) {
            return false;
        }
        if (this.doubleFace != other.doubleFace) {
            return false;
        }
        return this.minBlockLight == other.minBlockLight;
    }

    public static enum LaserSide {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

        public static final LaserSide[] VALUES;

        static {
            VALUES = LaserSide.values();
        }
    }

    public static class LaserRow {
        public final ISprite sprite;
        public final double uMin;
        public final double vMin;
        public final double uMax;
        public final double vMax;
        public final int width;
        public final int height;
        public final LaserSide[] validSides;

        public LaserRow(ISprite sprite, int uMin, int vMin, int uMax, int vMax, int textureSize, LaserSide ... sides) {
            this.sprite = sprite;
            this.uMin = (double)uMin / (double)textureSize;
            this.vMin = (double)vMin / (double)textureSize;
            this.uMax = (double)uMax / (double)textureSize;
            this.vMax = (double)vMax / (double)textureSize;
            this.width = uMax - uMin;
            this.height = vMax - vMin;
            this.validSides = sides == null || sides.length == 0 ? LaserSide.VALUES : sides;
        }

        public LaserRow(ISprite sprite, int uMin, int vMin, int uMax, int vMax, LaserSide ... sides) {
            this(sprite, uMin, vMin, uMax, vMax, 16, sides);
        }

        public LaserRow(LaserRow from, ISprite sprite) {
            this.sprite = sprite;
            this.uMin = from.uMin;
            this.vMin = from.vMin;
            this.uMax = from.uMax;
            this.vMax = from.vMax;
            this.width = from.width;
            this.height = from.height;
            this.validSides = from.validSides;
        }
    }

    public static class LaserType {
        public final LaserRow capStart;
        public final LaserRow capEnd;
        public final LaserRow start;
        public final LaserRow end;
        public final LaserRow[] variations;

        public LaserType(LaserRow capStart, LaserRow start, LaserRow[] middle, LaserRow end, LaserRow capEnd) {
            this.capStart = capStart;
            this.start = start;
            this.variations = middle;
            this.end = end;
            this.capEnd = capEnd;
        }

        public LaserType(LaserType from, SpriteHolderRegistry.SpriteHolder replacementSprite) {
            this.capStart = new LaserRow(from.capStart, replacementSprite);
            this.capEnd = new LaserRow(from.capEnd, replacementSprite);
            this.start = new LaserRow(from.start, replacementSprite);
            this.end = new LaserRow(from.end, replacementSprite);
            this.variations = new LaserRow[from.variations.length];
            for (int i = 0; i < this.variations.length; ++i) {
                this.variations[i] = new LaserRow(from.variations[i], replacementSprite);
            }
        }
    }
}

