/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.render.laser;

import buildcraft.lib.client.render.laser.ILaserRenderer;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LaserCompiledBuffer {
    private static final int DOUBLE_STRIDE = 5;
    private static final int INT_STRIDE = 2;
    private final int vertices;
    private final double[] da;
    private final int[] ia;

    public LaserCompiledBuffer(int vertices, double[] da, int[] ia) {
        this.vertices = vertices;
        this.da = da;
        this.ia = ia;
    }

    public void render(BufferBuilder buffer) {
        for (int i = 0; i < this.vertices; ++i) {
            buffer.func_181662_b(this.da[5 * i + 0], this.da[5 * i + 1], this.da[5 * i + 2]);
            int c = this.ia[2 * i + 0];
            buffer.func_181669_b(c & 0xFF, c >> 8 & 0xFF, c >> 16 & 0xFF, c >> 24 & 0xFF);
            buffer.func_187315_a(this.da[5 * i + 3], this.da[5 * i + 4]);
            int lmap = this.ia[2 * i + 1];
            buffer.func_187314_a(lmap >> 16 & 0xFFFF, lmap & 0xFFFF);
            buffer.func_181675_d();
        }
    }

    public static class Builder
    implements ILaserRenderer {
        private final boolean useNormalColour;
        private final TDoubleArrayList doubleData = new TDoubleArrayList();
        private final TIntArrayList intData = new TIntArrayList();
        private int vertices = 0;

        public Builder(boolean useNormalColour) {
            this.useNormalColour = useNormalColour;
        }

        @Override
        public void vertex(double x, double y, double z, double u, double v, int lmap, float nx, float ny, float nz, float diffuse) {
            this.doubleData.add(x);
            this.doubleData.add(y);
            this.doubleData.add(z);
            if (this.useNormalColour) {
                int c = (int)(diffuse * 255.0f);
                this.intData.add(c | c << 8 | c << 16 | 0xFF000000);
            } else {
                this.intData.add(-1);
            }
            this.doubleData.add(u);
            this.doubleData.add(v);
            this.intData.add(lmap);
            ++this.vertices;
        }

        public LaserCompiledBuffer build() {
            return new LaserCompiledBuffer(this.vertices, this.doubleData.toArray(), this.intData.toArray());
        }
    }
}

