/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.model;

import buildcraft.api.core.BCLog;
import buildcraft.lib.client.model.ModelHolder;
import buildcraft.lib.client.model.ModelHolderRegistry;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.client.model.json.JsonModel;
import buildcraft.lib.client.model.json.JsonModelPart;
import buildcraft.lib.client.model.json.JsonQuad;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;

@Deprecated
public class ModelHolderStatic
extends ModelHolder {
    private final ImmutableMap<String, String> textureLookup;
    private final boolean allowTextureFallthrough;
    private MutableQuad[][] quads;
    private JsonModel rawModel;
    private boolean unseen = true;

    public ModelHolderStatic(String location) {
        this(location, (ImmutableMap<String, String>)ImmutableMap.of(), false);
    }

    public ModelHolderStatic(String location, String[][] textures, boolean allowTextureFallthrough) {
        this(location, ModelHolderStatic.genTextureMap(textures), allowTextureFallthrough);
    }

    public ModelHolderStatic(String modelLocation, ImmutableMap<String, String> textureLookup, boolean allowTextureFallthrough) {
        super(modelLocation);
        this.textureLookup = textureLookup;
        this.allowTextureFallthrough = allowTextureFallthrough;
    }

    @Override
    public boolean hasBakedQuads() {
        return this.quads != null;
    }

    private static ImmutableMap<String, String> genTextureMap(String[][] textures) {
        if (textures == null || textures.length == 0) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Object[] objectArray : textures) {
            if (objectArray.length != 2) {
                throw new IllegalArgumentException("Must have 2 elements (key,value) but got " + Arrays.toString(objectArray));
            }
            if (!objectArray[0].startsWith("~")) {
                throw new IllegalArgumentException("Key must start with '~' otherwise it will never be used!");
            }
            builder.put(objectArray[0], objectArray[1]);
        }
        return builder.build();
    }

    @Override
    protected void onTextureStitchPre(Set<ResourceLocation> toRegisterSprites) {
        this.rawModel = null;
        this.quads = null;
        this.failReason = null;
        try {
            this.rawModel = JsonModel.deserialize(this.modelLocation);
        }
        catch (JsonParseException jse) {
            this.rawModel = null;
            this.failReason = "The model had errors: " + jse.getMessage();
            BCLog.logger.warn("[lib.model.holder] Failed to load the model " + this.modelLocation + " because " + jse.getMessage());
        }
        catch (IOException io) {
            this.rawModel = null;
            this.failReason = "The model did not exist in any resource pack: " + io.getMessage();
            BCLog.logger.warn("[lib.model.holder] Failed to load the model " + this.modelLocation + " because " + io.getMessage());
        }
        if (this.rawModel != null) {
            if (ModelHolderRegistry.DEBUG) {
                BCLog.logger.info("[lib.model.holder] The model " + this.modelLocation + " requires these sprites:");
            }
            for (Map.Entry<String, String> entry : this.rawModel.textures.entrySet()) {
                String lookup = entry.getValue();
                if (lookup.startsWith("#")) continue;
                if (lookup.startsWith("~") && this.textureLookup.containsKey((Object)lookup)) {
                    lookup = (String)this.textureLookup.get((Object)lookup);
                }
                if (lookup == null || lookup.startsWith("#") || lookup.startsWith("~")) {
                    if (!this.allowTextureFallthrough) {
                        this.failReason = "The sprite lookup '" + lookup + "' did not exist in ay of the maps";
                        this.rawModel = null;
                        break;
                    }
                } else {
                    toRegisterSprites.add(new ResourceLocation(lookup));
                }
                if (!ModelHolderRegistry.DEBUG) continue;
                BCLog.logger.info("[lib.model.holder]  - " + lookup);
            }
        }
    }

    @Override
    protected void onModelBake() {
        if (this.rawModel == null) {
            this.quads = null;
        } else {
            MutableQuad[] cut = this.bakePart(this.rawModel.cutoutElements);
            MutableQuad[] trans = this.bakePart(this.rawModel.translucentElements);
            this.quads = new MutableQuad[][]{cut, trans};
            this.rawModel = null;
        }
    }

    private MutableQuad[] bakePart(JsonModelPart[] a) {
        TextureAtlasSprite missingSprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        ArrayList<MutableQuad> list = new ArrayList<MutableQuad>();
        for (JsonModelPart part : a) {
            for (JsonQuad quad : part.quads) {
                String lookup = quad.texture;
                for (int attempts = 0; lookup.startsWith("#") && this.rawModel.textures.containsKey(lookup) && attempts < 10; ++attempts) {
                    lookup = this.rawModel.textures.get(lookup);
                }
                if (lookup.startsWith("~") && this.textureLookup.containsKey((Object)lookup)) {
                    lookup = (String)this.textureLookup.get((Object)lookup);
                }
                TextureAtlasSprite sprite = lookup.startsWith("#") || lookup.startsWith("~") ? (this.allowTextureFallthrough ? null : missingSprite) : Minecraft.func_71410_x().func_147117_R().func_110572_b(lookup);
                list.add(quad.toQuad(sprite));
            }
        }
        return list.toArray(new MutableQuad[list.size()]);
    }

    private MutableQuad[][] getQuadsChecking() {
        if (this.quads == null) {
            if (this.unseen) {
                this.unseen = false;
                String warnText = "[lib.model.holder] Tried to use the model " + this.modelLocation + " before it was baked!";
                if (ModelHolderRegistry.DEBUG) {
                    BCLog.logger.warn(warnText, new Throwable());
                } else {
                    BCLog.logger.warn(warnText);
                }
            }
            return new MutableQuad[][]{MutableQuad.EMPTY_ARRAY, MutableQuad.EMPTY_ARRAY};
        }
        return this.quads;
    }

    public MutableQuad[] getCutoutQuads() {
        return this.getQuadsChecking()[0];
    }

    public MutableQuad[] getTranslucentQuads() {
        return this.getQuadsChecking()[1];
    }
}

