/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.loader;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.lib.client.guide.entry.PageEntry;
import buildcraft.lib.client.guide.loader.IPageLoaderText;
import buildcraft.lib.client.guide.loader.XmlPageLoader;
import buildcraft.lib.client.guide.parts.GuidePageFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.ResourceLocation;

public enum MarkdownPageLoader implements IPageLoaderText
{
    INSTANCE;

    public static final boolean DEBUG;

    public static ItemStack loadComplexItemStack(String line) {
        String[] args = line.split(",");
        if (args.length == 0) {
            BCLog.logger.warn("[lib.guide.loader.markdown] " + line + " was not a valid complex item string!");
            return ItemStack.field_190927_a;
        }
        ItemStack stack = null;
        Item item = Item.func_111206_d((String)args[0].trim());
        if (item == null) {
            BCLog.logger.warn("[lib.guide.loader.markdown] " + args[0] + " was not a valid item!");
            return ItemStack.field_190927_a;
        }
        stack = new ItemStack(item);
        if (args.length == 1) {
            return stack;
        }
        int stackSize = 1;
        try {
            stackSize = Integer.parseInt(args[1].trim());
        }
        catch (NumberFormatException nfe) {
            BCLog.logger.warn("[lib.guide.loader.markdown] " + args[1] + " was not a valid number: " + nfe.getLocalizedMessage());
        }
        stack.func_190920_e(stackSize);
        if (args.length == 2) {
            return stack;
        }
        try {
            int meta = Integer.parseInt(args[2].trim());
            if (meta == -1) {
                meta = Short.MAX_VALUE;
            }
            stack = new ItemStack(stack.func_77973_b(), stack.func_190916_E(), meta);
        }
        catch (NumberFormatException nfe) {
            BCLog.logger.warn("[lib.guide.loader.markdown] " + args[2] + " was not a valid number: " + nfe.getLocalizedMessage());
        }
        if (args.length == 3) {
            return stack;
        }
        String nbtString = args[3];
        try {
            stack.func_77982_d(JsonToNBT.func_180713_a((String)nbtString));
        }
        catch (NBTException e) {
            BCLog.logger.warn("[lib.guide.loader.markdown] " + nbtString + " was not a valid nbt tag: " + e.getLocalizedMessage());
        }
        return stack;
    }

    @Override
    public GuidePageFactory loadPage(BufferedReader reader, ResourceLocation name, PageEntry<?> entry, Profiler prof) throws IOException {
        String line;
        prof.func_76320_a("md");
        StringBuilder replaced = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            line = MarkdownPageLoader.replaceSpecialForXml(line);
            replaced.append(line);
            replaced.append('\n');
        }
        BufferedReader nReader = new BufferedReader(new StringReader(replaced.toString()));
        prof.func_76319_b();
        return XmlPageLoader.INSTANCE.loadPage(nReader, name, entry, prof);
    }

    private static String replaceSpecialForXml(String line) {
        if (line.startsWith("$[special.") && line.indexOf(93) > 0) {
            String post;
            int end = line.indexOf(93);
            switch (post = line.substring("$[special.".length(), end)) {
                case "new_page": {
                    BCLog.logger.warn("[lib.guide.markdown] Found deprecated element '" + line + "', it should be replaced with '<new_page/>'");
                    return "<new_page/>";
                }
                case "all_crafting": {
                    String stack = line.substring(end + 1);
                    String additional = "";
                    if (stack.startsWith("\"") && stack.endsWith("\"")) {
                        stack = stack.substring(1, stack.length() - 1);
                    }
                    if (stack.startsWith("(") && stack.endsWith(")")) {
                        stack = stack.substring(1, stack.length() - 1);
                    } else if (stack.startsWith("{") && stack.contains("}")) {
                        int curlyStart = stack.indexOf(125);
                        String[] split = (stack = stack.substring(1, curlyStart)).split(",");
                        if (split.length > 0) {
                            stack = split[0];
                        }
                        if (split.length > 1) {
                            additional = additional + " count=\"" + split[1] + "\"";
                        }
                        if (split.length > 2) {
                            additional = additional + " data=\"" + split[2] + "\"";
                        }
                    }
                    String str = "<recipes_usages stack=\"" + stack + "\"" + additional + "/>";
                    BCLog.logger.warn("[lib.guide.markdown] Found deprecated element '" + line + "', it should be replaced with '" + str + "'");
                    return str;
                }
            }
        } else if (line.startsWith("#")) {
            while (line.startsWith("#")) {
                line = line.substring(1);
            }
            line = line.trim();
            return "<chapter name=\"" + line + "\"/>";
        }
        return line;
    }

    static {
        DEBUG = BCDebugging.shouldDebugLog("lib.markdown");
    }
}

