/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.block;

import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.lib.block.IBlockWithFacing;
import buildcraft.lib.registry.CreativeTabManager;
import buildcraft.lib.registry.TagManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class BlockBCBase_Neptune
extends Block {
    public static final IProperty<EnumFacing> PROP_FACING = BuildCraftProperties.BLOCK_FACING;
    public static final IProperty<EnumFacing> BLOCK_FACING_6 = BuildCraftProperties.BLOCK_FACING_6;
    public final String id;

    public BlockBCBase_Neptune(Material material, String id) {
        super(material);
        if (id == null) {
            id = "";
        }
        this.id = id;
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        if (!id.isEmpty()) {
            this.func_149663_c(TagManager.getTag(id, TagManager.EnumTagType.UNLOCALIZED_NAME));
            this.setRegistryName(TagManager.getTag(id, TagManager.EnumTagType.REGISTRY_NAME));
            this.func_149647_a(CreativeTabManager.getTab(TagManager.getTag(id, TagManager.EnumTagType.CREATIVE_TAB)));
        }
        if (this instanceof IBlockWithFacing) {
            IProperty<EnumFacing> facingProp = ((IBlockWithFacing)((Object)this)).getFacingProperty();
            this.func_180632_j(this.func_176223_P().func_177226_a(facingProp, (Comparable)EnumFacing.NORTH));
        }
    }

    protected void addProperties(List<IProperty<?>> properties) {
        if (this instanceof IBlockWithFacing) {
            properties.add(((IBlockWithFacing)((Object)this)).getFacingProperty());
        }
    }

    protected BlockStateContainer func_180661_e() {
        ArrayList properties = new ArrayList();
        this.addProperties(properties);
        return new BlockStateContainer((Block)this, properties.toArray(new IProperty[0]));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (this instanceof IBlockWithFacing) {
            meta = ((IBlockWithFacing)((Object)this)).canFaceVertically() ? (meta |= ((EnumFacing)state.func_177229_b(((IBlockWithFacing)((Object)this)).getFacingProperty())).func_176745_a()) : (meta |= ((EnumFacing)state.func_177229_b(((IBlockWithFacing)((Object)this)).getFacingProperty())).func_176736_b());
        }
        return meta;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        if (this instanceof IBlockWithFacing) {
            IBlockWithFacing b = (IBlockWithFacing)((Object)this);
            IProperty<EnumFacing> prop = b.getFacingProperty();
            state = b.canFaceVertically() ? state.func_177226_a(prop, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))) : state.func_177226_a(prop, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
        }
        return state;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        if (this instanceof IBlockWithFacing) {
            IProperty<EnumFacing> prop = ((IBlockWithFacing)((Object)this)).getFacingProperty();
            EnumFacing facing = (EnumFacing)state.func_177229_b(prop);
            state = state.func_177226_a(prop, (Comparable)rot.func_185831_a(facing));
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        if (this instanceof IBlockWithFacing) {
            IProperty<EnumFacing> prop = ((IBlockWithFacing)((Object)this)).getFacingProperty();
            EnumFacing facing = (EnumFacing)state.func_177229_b(prop);
            state = state.func_177226_a(prop, (Comparable)mirror.func_185803_b(facing));
        }
        return state;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        if (this instanceof IBlockWithFacing) {
            EnumFacing orientation = placer.func_174811_aO();
            IBlockWithFacing b = (IBlockWithFacing)((Object)this);
            if (b.canFaceVertically() && MathHelper.func_76135_e((float)((float)placer.field_70165_t - (float)pos.func_177958_n())) < 2.0f && MathHelper.func_76135_e((float)((float)placer.field_70161_v - (float)pos.func_177952_p())) < 2.0f) {
                double y = placer.field_70163_u + (double)placer.func_70047_e();
                if (y - (double)pos.func_177956_o() > 2.0) {
                    orientation = EnumFacing.DOWN;
                }
                if ((double)pos.func_177956_o() - y > 0.0) {
                    orientation = EnumFacing.UP;
                }
            }
            state = state.func_177226_a(b.getFacingProperty(), (Comparable)orientation.func_176734_d());
        }
        return state;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        if (this instanceof IBlockWithFacing && !((IBlockWithFacing)((Object)this)).canBeRotated(world, pos, world.func_180495_p(pos))) {
            return false;
        }
        return super.rotateBlock(world, pos, axis);
    }

    public static boolean isExceptBlockForAttachWithPiston(Block attachBlock) {
        return Block.func_193382_c((Block)attachBlock);
    }
}

