/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.core;

import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;

public enum EnumPipePart implements IStringSerializable
{
    DOWN(EnumFacing.DOWN),
    UP(EnumFacing.UP),
    NORTH(EnumFacing.NORTH),
    SOUTH(EnumFacing.SOUTH),
    WEST(EnumFacing.WEST),
    EAST(EnumFacing.EAST),
    CENTER(null);

    public static final EnumPipePart[] VALUES;
    public static final EnumPipePart[] FACES;
    public static final EnumPipePart[] HORIZONTALS;
    private static final Map<EnumFacing, EnumPipePart> facingMap;
    private static final Map<String, EnumPipePart> nameMap;
    private static final int MAX_VALUES;
    public final EnumFacing face;

    private static EnumPipePart[] fromFacingArray(EnumFacing ... faces) {
        EnumPipePart[] arr = new EnumPipePart[faces.length];
        for (int i = 0; i < faces.length; ++i) {
            arr[i] = EnumPipePart.fromFacing(faces[i]);
        }
        return arr;
    }

    public static int ordinal(EnumFacing face) {
        return face == null ? 6 : face.ordinal();
    }

    public static EnumPipePart fromFacing(EnumFacing face) {
        if (face == null) {
            return CENTER;
        }
        return facingMap.get(face);
    }

    public static EnumPipePart[] validFaces() {
        return FACES;
    }

    public static EnumPipePart fromMeta(int meta) {
        if (meta < 0 || meta >= MAX_VALUES) {
            return CENTER;
        }
        return VALUES[meta];
    }

    private EnumPipePart(EnumFacing face) {
        this.face = face;
    }

    public int getIndex() {
        if (this.face == null) {
            return 6;
        }
        return this.face.func_176745_a();
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public EnumPipePart next() {
        switch (this) {
            case DOWN: {
                return EAST;
            }
            case EAST: {
                return NORTH;
            }
            case NORTH: {
                return SOUTH;
            }
            case SOUTH: {
                return UP;
            }
            case UP: {
                return WEST;
            }
            case WEST: {
                return DOWN;
            }
        }
        return DOWN;
    }

    public EnumPipePart opposite() {
        if (this == CENTER) {
            return CENTER;
        }
        return EnumPipePart.fromFacing(this.face.func_176734_d());
    }

    public static EnumPipePart readFromNBT(NBTBase base) {
        if (base == null) {
            return CENTER;
        }
        if (base instanceof NBTTagString) {
            NBTTagString nbtString = (NBTTagString)base;
            String string = nbtString.func_150285_a_();
            return nameMap.getOrDefault(string, CENTER);
        }
        byte ord = ((NBTPrimitive)base).func_150290_f();
        if (ord < 0 || ord > 6) {
            return CENTER;
        }
        return EnumPipePart.values()[ord];
    }

    public NBTBase writeToNBT() {
        return new NBTTagString(this.name());
    }

    static {
        VALUES = EnumPipePart.values();
        facingMap = Maps.newEnumMap(EnumFacing.class);
        nameMap = Maps.newHashMap();
        MAX_VALUES = EnumPipePart.values().length;
        for (EnumPipePart part : EnumPipePart.values()) {
            nameMap.put(part.name(), part);
            if (part.face == null) continue;
            facingMap.put(part.face, part);
        }
        FACES = EnumPipePart.fromFacingArray(EnumFacing.field_82609_l);
        HORIZONTALS = EnumPipePart.fromFacingArray(EnumFacing.field_176754_o);
    }
}

