/*
 * Decompiled with CFR 0.152.
 */
package baubles.common;

import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Config {
    public static Configuration config;
    public static boolean renderBaubles;

    public static void initialize(File file) {
        config = new Configuration(file);
        config.load();
        Config.load();
        MinecraftForge.EVENT_BUS.register(ConfigChangeListener.class);
    }

    public static void load() {
        String desc = "Set this to false to disable rendering of baubles in the player.";
        renderBaubles = config.getBoolean("baubleRender.enabled", "client", renderBaubles, desc);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void save() {
        config.save();
    }

    static {
        renderBaubles = true;
    }

    public static class ConfigChangeListener {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
            if (eventArgs.getModID().equals("baubles")) {
                Config.load();
            }
        }
    }
}

