/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.network;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import wanion.lib.WanionLib;
import wanion.lib.common.control.IControl;
import wanion.lib.common.control.IControlContainer;
import wanion.lib.common.control.IControlControllerProvider;
import wanion.lib.common.matching.IMatchingContainer;
import wanion.lib.common.matching.IMatchingControllerProvider;
import wanion.lib.common.matching.Matching;
import wanion.lib.network.ControlSync;
import wanion.lib.network.MatchingSync;

public class NetworkHelper {
    private NetworkHelper() {
    }

    public static void addControlListener(int windowId, @Nonnull IControlControllerProvider controlControllerProvider, @Nonnull EntityPlayerMP entityPlayerMP) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        controlControllerProvider.getControlController().getInstances().forEach(control -> control.writeToNBT(nbtTagCompound));
        WanionLib.networkWrapper.sendTo((IMessage)new ControlSync(windowId, nbtTagCompound), entityPlayerMP);
    }

    public static void detectAndSendControlChanges(int windowId, @Nonnull IControlContainer controlContainer) {
        List controlList = controlContainer.getControlController().compareContents(controlContainer.getContainerControlController());
        if (!controlList.isEmpty()) {
            controlContainer.getContainerControlController().forceAdd(controlList.stream().map(IControl::copy).collect(Collectors.toList()));
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            controlList.forEach(control -> control.writeToNBT(nbtTagCompound));
            for (IContainerListener containerListener : controlContainer.getListeners()) {
                if (!(containerListener instanceof EntityPlayerMP)) continue;
                WanionLib.networkWrapper.sendTo((IMessage)new ControlSync(windowId, nbtTagCompound), (EntityPlayerMP)containerListener);
            }
        }
    }

    public static void addMatchingListener(int windowId, @Nonnull IMatchingControllerProvider matchingControllerProvider, @Nonnull EntityPlayerMP entityPlayerMP) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        matchingControllerProvider.getMatchingController().getInstances().forEach(control -> control.writeToNBT(nbtTagCompound));
        WanionLib.networkWrapper.sendTo((IMessage)new MatchingSync(windowId, nbtTagCompound), entityPlayerMP);
    }

    public static void detectAndSendMatchingChanges(int windowId, @Nonnull IMatchingContainer matchingContainer) {
        List<Matching> controlList = matchingContainer.getMatchingController().compareContents(matchingContainer.getContainerMatchingController());
        if (!controlList.isEmpty()) {
            controlList.stream().map(Matching::copy).collect(Collectors.toList()).forEach(matchingContainer.getContainerMatchingController()::add);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            controlList.forEach(control -> control.writeToNBT(nbtTagCompound));
            for (IContainerListener containerListener : matchingContainer.getListeners()) {
                if (!(containerListener instanceof EntityPlayerMP)) continue;
                WanionLib.networkWrapper.sendTo((IMessage)new MatchingSync(windowId, nbtTagCompound), (EntityPlayerMP)containerListener);
            }
        }
    }
}

