/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class Dependencies<D> {
    private final Map<Class, D> dependencies = new IdentityHashMap<Class, D>();
    private final Collection<D> instances = Collections.unmodifiableCollection(this.dependencies.values());
    private final Map<Class, DependenceWatcher<? extends D>> dependenciesWatchers = new IdentityHashMap<Class, DependenceWatcher<? extends D>>();

    public Dependencies() {
    }

    public Dependencies(D ... dependencies) {
        this.add(dependencies);
    }

    public Dependencies(@Nonnull Collection<D> dependencies) {
        this.add(dependencies);
    }

    public Dependencies(@Nonnull Dependencies<D> dependencies) {
        this.add(dependencies.getInstances());
    }

    public final <I extends D> void add(Class<? extends I> typeClass) {
        if (this.dependencies.containsKey(typeClass)) {
            return;
        }
        DependenceWatcher<D> dependenceWatcher = this.dependenciesWatchers.get(typeClass);
        if (dependenceWatcher != null) {
            this.add((I)dependenceWatcher.instantiate());
            return;
        }
        try {
            Constructor<I> constructor = typeClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            this.add(constructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public final <I extends D> void add(I instance) {
        Class<?> typeClass;
        Class<?> clazz = typeClass = instance != null ? instance.getClass() : null;
        if (this.dependencies.containsKey(typeClass)) {
            return;
        }
        this.dependencies.put(typeClass, instance);
    }

    public final <I extends D> void add(I ... instances) {
        for (I instance : instances) {
            this.add(instance);
        }
    }

    public final <I extends D> void add(@Nonnull Collection<I> instances) {
        instances.forEach(this::add);
    }

    public final <I extends D> void forceAdd(@Nonnull I instance) {
        this.dependencies.put(instance.getClass(), instance);
    }

    public final <I extends D> void forceAdd(I ... instances) {
        for (I instance : instances) {
            this.dependencies.put(instance.getClass(), instance);
        }
    }

    public final <I extends D> void forceAdd(@Nonnull Collection<I> instances) {
        instances.forEach(instance -> this.dependencies.put(instance.getClass(), instance));
    }

    public final <I extends D> I get(Class<I> typeClass) {
        D instance = this.dependencies.get(typeClass);
        if (instance != null) {
            return (I)instance;
        }
        this.add((I)typeClass);
        return (I)this.dependencies.get(typeClass);
    }

    public final <I extends D> I get(@Nonnull I instance) {
        Class<?> typeClass = instance.getClass();
        return (I)this.get((I)typeClass);
    }

    public final Collection<D> getDependencies() {
        return this.dependencies.keySet();
    }

    public final Collection<D> getInstances() {
        return this.instances;
    }

    public final boolean contains(Class<? extends D> typeClass) {
        return this.dependencies.containsKey(typeClass);
    }

    @Nonnull
    public final <I extends D> List<I> compareContents(@Nonnull Dependencies<D> dependencies) {
        if (!this.getDependencies().equals(dependencies.getDependencies())) {
            return Collections.emptyList();
        }
        ArrayList<D> differences = new ArrayList<D>();
        for (D dependency : this.instances) {
            if (dependency.equals(dependencies.get(dependency))) continue;
            differences.add(dependency);
        }
        return differences;
    }

    public final void subscribe(DependenceWatcher<? extends D> dependenceWatcher) {
        if (!this.dependenciesWatchers.containsKey(((DependenceWatcher)dependenceWatcher).dependenceClass)) {
            this.dependenciesWatchers.put(((DependenceWatcher)dependenceWatcher).dependenceClass, dependenceWatcher);
        }
    }

    public abstract class DependenceWatcher<W extends D> {
        private final Class<W> dependenceClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

        protected DependenceWatcher() {
        }

        @Nonnull
        public abstract W instantiate();
    }
}

