/*
 * Decompiled with CFR 0.152.
 */
package kenkron.antiqueatlasoverlay;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.RegistrarAntiqueAtlas;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.client.BiomeTextureMap;
import hunternif.mc.atlas.client.SubTile;
import hunternif.mc.atlas.client.SubTileQuartet;
import hunternif.mc.atlas.client.Textures;
import hunternif.mc.atlas.client.TileRenderIterator;
import hunternif.mc.atlas.client.gui.GuiAtlas;
import hunternif.mc.atlas.core.DimensionData;
import hunternif.mc.atlas.marker.DimensionMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkersData;
import hunternif.mc.atlas.registry.MarkerRegistry;
import hunternif.mc.atlas.registry.MarkerRenderInfo;
import hunternif.mc.atlas.registry.MarkerType;
import hunternif.mc.atlas.util.AtlasRenderHelper;
import hunternif.mc.atlas.util.Rect;
import java.util.List;
import kenkron.antiqueatlasoverlay.AAOConfig;
import kenkron.antiqueatlasoverlay.AntiqueAtlasOverlayMod;
import kenkron.antiqueatlasoverlay.SetTileRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(modid="antiqueatlasoverlay")
public class AAORenderEventReceiver {
    private static final int CHUNK_SIZE = 16;
    private static int screenScale = 1;
    private static ScaledResolution res;

    private static Integer getPlayerAtlas(EntityPlayer player) {
        if (!SettingsConfig.gameplay.itemNeeded) {
            return player.func_110124_au().hashCode();
        }
        ItemStack stack = player.func_184592_cb();
        if (!stack.func_190926_b() && stack.func_77973_b() == RegistrarAntiqueAtlas.ATLAS) {
            return stack.func_77952_i();
        }
        for (int i = 0; i < 9; ++i) {
            stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != RegistrarAntiqueAtlas.ATLAS) continue;
            return stack.func_77952_i();
        }
        return null;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void eventHandler(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!AAOConfig.appearance.enabled) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiAtlas) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Integer atlas = null;
        if (AAOConfig.appearance.requiresHold) {
            ItemStack stack = player.func_184614_ca();
            ItemStack stack2 = player.func_184592_cb();
            if (!stack.func_190926_b() && stack.func_77973_b() == RegistrarAntiqueAtlas.ATLAS) {
                atlas = stack.func_77952_i();
            } else if (!stack2.func_190926_b() && stack2.func_77973_b() == RegistrarAntiqueAtlas.ATLAS) {
                atlas = stack2.func_77952_i();
            }
        } else {
            atlas = AAORenderEventReceiver.getPlayerAtlas((EntityPlayer)player);
        }
        if (atlas != null) {
            int gameWidth = event.getResolution().func_78326_a();
            int gameHeight = event.getResolution().func_78328_b();
            Rect bounds = new Rect().setOrigin(AAOConfig.position.xPosition, AAOConfig.position.yPosition);
            if (AAOConfig.position.alignRight) {
                bounds.minX = gameWidth - (AAOConfig.position.width + AAOConfig.position.xPosition);
            }
            if (AAOConfig.position.alignBottom) {
                bounds.minY = gameHeight - (AAOConfig.position.height + AAOConfig.position.yPosition);
            }
            bounds.setSize(AAOConfig.position.width, AAOConfig.position.height);
            res = event.getResolution();
            AAORenderEventReceiver.drawMinimap(bounds, atlas, player.func_174791_d(), player.func_70079_am(), player.field_71093_bK);
        }
    }

    private static void drawMinimap(Rect shape, int atlasID, Vec3d position, float rotation, int dimension) {
        screenScale = new ScaledResolution(Minecraft.func_71410_x()).func_78325_e();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        AtlasRenderHelper.drawFullTexture(Textures.BOOK, shape.minX, shape.minY, shape.getWidth(), shape.getHeight());
        Rect innerShape = new Rect(shape.minX + Math.round(AAOConfig.appearance.borderX * (float)shape.getWidth()), shape.minY + Math.round(AAOConfig.appearance.borderY * (float)shape.getHeight()), shape.maxX - Math.round(AAOConfig.appearance.borderX * (float)shape.getWidth()), shape.maxY - Math.round(AAOConfig.appearance.borderY * (float)shape.getHeight()));
        AAORenderEventReceiver.drawTiles(innerShape, atlasID, position, dimension);
        if (AAOConfig.appearance.markerSize > 0) {
            AAORenderEventReceiver.drawMarkers(innerShape, atlasID, position, dimension);
            int shapeMiddleX = (shape.minX + shape.maxX) / 2;
            int shapeMiddleY = (shape.minY + shape.maxY) / 2;
            AAORenderEventReceiver.drawPlayer(shapeMiddleX, shapeMiddleY, rotation);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AtlasRenderHelper.drawFullTexture(Textures.BOOK_FRAME, shape.minX, shape.minY, shape.getWidth(), shape.getHeight());
        GlStateManager.func_179084_k();
    }

    private static void drawTiles(Rect shape, int atlasID, Vec3d position, int dimension) {
        GL11.glEnable((int)3089);
        AAORenderEventReceiver.glScissorGUI(shape);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        DimensionData biomeData = AntiqueAtlasMod.atlasData.getAtlasData(atlasID, (World)Minecraft.func_71410_x().field_71441_e).getDimensionData(dimension);
        TileRenderIterator iter = new TileRenderIterator(biomeData);
        Rect iteratorScope = AAORenderEventReceiver.getChunkCoverage(position, shape);
        iter.setScope(iteratorScope);
        iter.setStep(1);
        Vec3d chunkPosition = new Vec3d(position.field_72450_a / 16.0, position.field_72448_b / 16.0, position.field_72449_c / 16.0);
        int shapeMiddleX = (shape.minX + shape.maxX) / 2;
        int shapeMiddleY = (shape.minY + shape.maxY) / 2;
        SetTileRenderer renderer = new SetTileRenderer(AAOConfig.appearance.tileSize / 2);
        while (iter.hasNext()) {
            SubTileQuartet subtiles = iter.next();
            for (SubTile subtile : subtiles) {
                if (subtile == null || subtile.tile == null) continue;
                float relativeChunkPositionX = (float)((double)subtile.x / 2.0 + (double)iteratorScope.minX - chunkPosition.field_72450_a);
                float relativeChunkPositionY = (float)((double)subtile.y / 2.0 + (double)iteratorScope.minY - chunkPosition.field_72449_c);
                renderer.addTileCorner(BiomeTextureMap.instance().getTexture(subtile.tile), shapeMiddleX + (int)Math.floor(relativeChunkPositionX * (float)AAOConfig.appearance.tileSize), shapeMiddleY + (int)Math.floor(relativeChunkPositionY * (float)AAOConfig.appearance.tileSize), subtile.getTextureU(), subtile.getTextureV());
            }
        }
        renderer.draw();
        GL11.glDisable((int)3089);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawMarkers(Rect shape, int atlasID, Vec3d position, int dimension) {
        GL11.glEnable((int)3089);
        AAORenderEventReceiver.glScissorGUI(shape);
        DimensionData biomeData = AntiqueAtlasMod.atlasData.getAtlasData(atlasID, (World)Minecraft.func_71410_x().field_71441_e).getDimensionData(dimension);
        DimensionMarkersData globalMarkersData = AntiqueAtlasMod.globalMarkersData.getData().getMarkersDataInDimension(dimension);
        AAORenderEventReceiver.drawMarkersData(globalMarkersData, shape, biomeData, position);
        MarkersData markersData = AntiqueAtlasMod.markersData.getMarkersData(atlasID, (World)Minecraft.func_71410_x().field_71441_e);
        DimensionMarkersData localMarkersData = null;
        if (markersData != null) {
            localMarkersData = markersData.getMarkersDataInDimension(dimension);
        }
        AAORenderEventReceiver.drawMarkersData(localMarkersData, shape, biomeData, position);
        GL11.glDisable((int)3089);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawPlayer(float x, float y, float rotation) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179114_b((float)(180.0f + rotation), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(-AAOConfig.appearance.playerIconWidth / 2), (float)(-AAOConfig.appearance.playerIconHeight / 2), (float)0.0f);
        AtlasRenderHelper.drawFullTexture(Textures.PLAYER, 0.0, 0.0, AAOConfig.appearance.playerIconWidth, AAOConfig.appearance.playerIconHeight);
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawMarkersData(DimensionMarkersData markersData, Rect shape, DimensionData biomeData, Vec3d position) {
        Rect markerShape = new Rect(shape.minX - AAOConfig.appearance.markerSize / 2, shape.minY - AAOConfig.appearance.markerSize / 2, shape.maxX + AAOConfig.appearance.markerSize / 2, shape.maxY + AAOConfig.appearance.markerSize / 2);
        Rect mcchunks = AAORenderEventReceiver.getChunkCoverage(position, markerShape);
        Rect chunks = new Rect((int)Math.floor(mcchunks.minX / 8), (int)Math.floor(mcchunks.minY / 8), (int)Math.ceil(mcchunks.maxX / 8), (int)Math.ceil(mcchunks.maxY / 8));
        int shapeMiddleX = (shape.minX + shape.maxX) / 2;
        int shapeMiddleY = (shape.minY + shape.maxY) / 2;
        for (int x = chunks.minX; x <= chunks.maxX; ++x) {
            for (int z = chunks.minY; z <= chunks.maxY; ++z) {
                List<Marker> markers = markersData.getMarkersAtChunk(Math.round(x), Math.round(z));
                if (markers == null) continue;
                for (Marker marker : markers) {
                    int relativeChunkPositionX = AAOConfig.appearance.tileSize * (2 * (marker.getX() / 2) - 2 * (int)Math.floor(position.field_72450_a / 2.0)) / 16;
                    int relativeChunkPositionY = AAOConfig.appearance.tileSize * (2 * (marker.getZ() / 2) - 2 * (int)Math.floor(position.field_72449_c / 2.0)) / 16;
                    int guiX = (int)Math.floor(shapeMiddleX - AAOConfig.appearance.markerSize / 2 + relativeChunkPositionX);
                    int guiY = (int)Math.floor(shapeMiddleY - AAOConfig.appearance.markerSize / 2 + relativeChunkPositionY);
                    AAORenderEventReceiver.renderMarker(marker, guiX, guiY, biomeData);
                }
            }
        }
    }

    private static void renderMarker(Marker marker, int x, int y, DimensionData biomeData) {
        if (!marker.isVisibleAhead() && !biomeData.hasTileAt(marker.getChunkX(), marker.getChunkZ())) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MarkerType m = MarkerRegistry.find(marker.getType());
        if (m == null) {
            AntiqueAtlasOverlayMod.LOGGER.warn("Could not find marker type for {}", (Object)marker.getId());
            return;
        }
        MarkerRenderInfo info = m.getRenderInfo(1.0, AAOConfig.appearance.tileSize, screenScale);
        AtlasRenderHelper.drawFullTexture(info.tex, x, y, AAOConfig.appearance.markerSize, AAOConfig.appearance.markerSize);
    }

    private static Rect getChunkCoverage(Vec3d position, Rect windowShape) {
        int minChunkX = (int)Math.floor(position.field_72450_a / 16.0 - (double)((float)windowShape.getWidth() / (2.0f * (float)AAOConfig.appearance.tileSize)));
        int minChunkY = (int)Math.floor(position.field_72449_c / 16.0 - (double)((float)windowShape.getHeight() / (2.0f * (float)AAOConfig.appearance.tileSize)));
        int maxChunkX = (int)Math.ceil(position.field_72450_a / 16.0 + (double)((float)windowShape.getWidth() / (2.0f * (float)AAOConfig.appearance.tileSize)));
        int maxChunkY = (int)Math.ceil(position.field_72449_c / 16.0 + (double)((float)windowShape.getHeight() / (2.0f * (float)AAOConfig.appearance.tileSize)));
        return new Rect(--minChunkX, --minChunkY, ++maxChunkX, ++maxChunkY);
    }

    private static void glScissorGUI(Rect shape) {
        int mcHeight = Minecraft.func_71410_x().field_71440_d;
        float scissorScaleX = (float)Minecraft.func_71410_x().field_71443_c * 1.0f / (float)res.func_78326_a();
        float scissorScaleY = (float)mcHeight * 1.0f / (float)res.func_78328_b();
        GL11.glScissor((int)((int)((float)shape.minX * scissorScaleX)), (int)((int)((float)mcHeight - (float)shape.maxY * scissorScaleY)), (int)((int)((float)shape.getWidth() * scissorScaleX)), (int)((int)((float)shape.getHeight() * scissorScaleY)));
    }
}

