/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network.client;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.marker.GlobalMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkersData;
import hunternif.mc.atlas.network.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class MarkersPacket
extends AbstractMessage.AbstractClientMessage<MarkersPacket> {
    private static final int GLOBAL = -1;
    private int atlasID;
    private int dimension;
    private final ListMultimap<String, Marker> markersByType = ArrayListMultimap.create();

    public MarkersPacket() {
    }

    public MarkersPacket(int atlasID, int dimension, Marker ... markers) {
        this.atlasID = atlasID;
        this.dimension = dimension;
        for (Marker marker : markers) {
            this.markersByType.put((Object)marker.getType(), (Object)marker);
        }
    }

    public MarkersPacket(int dimension, Marker ... markers) {
        this(-1, dimension, markers);
    }

    public MarkersPacket putMarker(Marker marker) {
        this.markersByType.put((Object)marker.getType(), (Object)marker);
        return this;
    }

    private boolean isGlobal() {
        return this.atlasID == -1;
    }

    @Override
    public void read(PacketBuffer buffer) throws IOException {
        this.atlasID = buffer.func_150792_a();
        this.dimension = buffer.func_150792_a();
        int typesLength = buffer.func_150792_a();
        for (int i = 0; i < typesLength; ++i) {
            String type = ByteBufUtils.readUTF8String((ByteBuf)buffer);
            int markersLength = buffer.func_150792_a();
            for (int j = 0; j < markersLength; ++j) {
                Marker marker = new Marker(buffer.func_150792_a(), type, ByteBufUtils.readUTF8String((ByteBuf)buffer), this.dimension, buffer.readInt(), buffer.readInt(), buffer.readBoolean());
                this.markersByType.put((Object)type, (Object)marker);
            }
        }
    }

    @Override
    public void write(PacketBuffer buffer) throws IOException {
        buffer.func_150787_b(this.atlasID);
        buffer.func_150787_b(this.dimension);
        Set types = this.markersByType.keySet();
        buffer.func_150787_b(types.size());
        for (String type : types) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)type);
            List markers = this.markersByType.get((Object)type);
            buffer.func_150787_b(markers.size());
            for (Marker marker : markers) {
                buffer.func_150787_b(marker.getId());
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)marker.getLabel());
                buffer.writeInt(marker.getX());
                buffer.writeInt(marker.getZ());
                buffer.writeBoolean(marker.isVisibleAhead());
            }
        }
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        GlobalMarkersData markersData = this.isGlobal() ? AntiqueAtlasMod.globalMarkersData.getData() : AntiqueAtlasMod.markersData.getMarkersData(this.atlasID, player.func_130014_f_());
        for (Marker marker : this.markersByType.values()) {
            ((MarkersData)markersData).loadMarker(marker);
        }
    }
}

