/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.marker;

import hunternif.mc.atlas.util.Log;
import hunternif.mc.atlas.util.ShortVec2;
import net.minecraft.client.resources.I18n;

public class Marker {
    public static final int TYPE_LIMIT = 128;
    public static final int LABEL_LIMIT = 128;
    private final int id;
    private final String type;
    private final String label;
    private final int dim;
    private final int x;
    private final int z;
    private final boolean visibleAhead;
    private boolean isGlobal;

    public Marker(int id, String type, String label, int dimension, int x, int z, boolean visibleAhead) {
        this.id = id;
        if (type.length() > 128) {
            type = type.substring(0, 128);
            Log.warn("Marker type is to long. Trimming to %d characters. Type: %s", 128, type);
        }
        this.type = type;
        if (label.length() > 128) {
            label = label.substring(0, 128);
            Log.warn("Marker type is to long. Trimming to %d characters. Type: %s", 128, label);
        }
        this.label = label == null ? "" : label;
        this.dim = dimension;
        this.x = x;
        this.z = z;
        this.visibleAhead = visibleAhead;
    }

    public int getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLocalizedLabel() {
        int whitespaceIndex = this.label.indexOf(32);
        if (whitespaceIndex == -1) {
            return I18n.func_135052_a((String)this.label, (Object[])new Object[0]);
        }
        String key = this.label.substring(0, whitespaceIndex);
        String param = this.label.substring(whitespaceIndex + 1);
        String translated = I18n.func_135052_a((String)key, (Object[])new Object[0]);
        if (!key.equals(translated)) {
            return String.format(I18n.func_135052_a((String)key, (Object[])new Object[0]), param);
        }
        return this.label;
    }

    public int getDimension() {
        return this.dim;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public int getChunkX() {
        return this.x >> 4;
    }

    public int getChunkZ() {
        return this.z >> 4;
    }

    public boolean isVisibleAhead() {
        return this.visibleAhead;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    Marker setGlobal(boolean value) {
        this.isGlobal = value;
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Marker)) {
            return false;
        }
        Marker marker = (Marker)obj;
        return this.id == marker.id;
    }

    public ShortVec2 getChunkCoords() {
        return new ShortVec2(this.x >> 4, this.z >> 4);
    }

    public String toString() {
        return "#" + this.id + "\"" + this.label + "\"@(" + this.x + ", " + this.z + ")";
    }
}

