/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.ext.watcher.impl;

import com.google.common.collect.Sets;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.ext.watcher.IStructureWatcher;
import hunternif.mc.atlas.ext.watcher.StructureWatcher;
import hunternif.mc.atlas.ext.watcher.WatcherPos;
import hunternif.mc.atlas.util.MathUtil;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import org.apache.commons.lang3.tuple.Pair;

public class StructureWatcherFortress
implements IStructureWatcher {
    private static final String ROOFED = "NeSCLT";
    private static final String ROOFED2 = "NeSCR";
    private static final String ROOFED_STAIRS = "NeCCS";
    private static final String ROOFED3 = "NeCTB";
    private static final String ROOFED4 = "NeSC";
    private static final String BRIDGE_GATE = "NeRC";
    private static final String ROOFED_CROSS = "NeSCSC";
    private static final String BRIDGE_CROSS = "NeBCr";
    private static final String START = "NeStart";
    private static final String BRIDGE = "NeBS";
    private static final String BRIDGE_END = "NeBEF";
    private static final String ENTRANCE = "NeCE";
    private static final String WART_STAIRS = "NeCSR";
    private static final String THRONE = "NeMT";
    private static final String TOWER = "NeSR";
    private final Set<WatcherPos> visited = new HashSet<WatcherPos>();

    public StructureWatcherFortress() {
        StructureWatcher.INSTANCE.addWatcher(this);
    }

    @Override
    @Nonnull
    public Set<WatcherPos> getVisited() {
        return this.visited;
    }

    @Override
    public boolean isDimensionValid(DimensionType type) {
        return type.func_186068_a() == -1;
    }

    @Override
    @Nullable
    public NBTTagCompound getStructureData(@Nonnull World world) {
        MapGenStructureData data = (MapGenStructureData)world.getPerWorldStorage().func_75742_a(MapGenStructureData.class, "Fortress");
        if (data == null) {
            return null;
        }
        return data.func_143041_a();
    }

    @Override
    @Nonnull
    public Set<Pair<WatcherPos, String>> visitStructure(@Nonnull World world, @Nonnull NBTTagCompound structureTag) {
        HashSet visits = Sets.newHashSet();
        Set tagSet = structureTag.func_150296_c();
        for (String coords : tagSet) {
            WatcherPos pos;
            if (!WatcherPos.POS_PATTERN.matcher(coords).matches() || this.visited.contains(pos = new WatcherPos(coords))) continue;
            NBTTagCompound tag = structureTag.func_74775_l(coords);
            this.visitFortress(world, tag);
            this.visited.add(pos);
            visits.add(Pair.of((Object)pos, (Object)"Nether Fortress"));
        }
        return visits;
    }

    private void visitFortress(World world, NBTTagCompound tag) {
        NBTTagList children = tag.func_150295_c("Children", 10);
        for (int i = 0; i < children.func_74745_c(); ++i) {
            int chunkX;
            int chunkZ;
            NBTTagCompound child = children.func_150305_b(i);
            String childID = child.func_74779_i("id");
            StructureBoundingBox boundingBox = new StructureBoundingBox(child.func_74759_k("BB"));
            if (BRIDGE.equals(childID)) {
                if (boundingBox.func_78883_b() > 16) {
                    String tileName = "netherBridgeX";
                    chunkZ = MathUtil.getCenter(boundingBox).func_177952_p() >> 4;
                    for (int x = boundingBox.field_78897_a; x < boundingBox.field_78893_d; x += 16) {
                        int chunkX2 = x >> 4;
                        if (!StructureWatcherFortress.noTileAt(world, chunkX2, chunkZ)) continue;
                        AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX2, chunkZ);
                    }
                    continue;
                }
                String tileName = "netherBridgeZ";
                chunkX = MathUtil.getCenter(boundingBox).func_177958_n() >> 4;
                for (int z = boundingBox.field_78896_c; z < boundingBox.field_78892_f; z += 16) {
                    int chunkZ2 = z >> 4;
                    if (!StructureWatcherFortress.noTileAt(world, chunkX, chunkZ2)) continue;
                    AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX, chunkZ2);
                }
                continue;
            }
            if (BRIDGE_END.equals(childID)) {
                int chunkZ3;
                String tileName;
                if (boundingBox.func_78883_b() > boundingBox.func_78880_d()) {
                    tileName = "netherBridgeEndX";
                    chunkX = boundingBox.field_78897_a >> 4;
                    chunkZ3 = MathUtil.getCenter(boundingBox).func_177952_p() >> 4;
                } else {
                    tileName = "netherBridgeEndZ";
                    chunkX = MathUtil.getCenter(boundingBox).func_177958_n() >> 4;
                    chunkZ3 = boundingBox.field_78896_c >> 4;
                }
                if (!StructureWatcherFortress.noTileAt(world, chunkX, chunkZ3)) continue;
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX, chunkZ3);
                continue;
            }
            int chunkX3 = MathUtil.getCenter(boundingBox).func_177958_n() >> 4;
            chunkZ = MathUtil.getCenter(boundingBox).func_177952_p() >> 4;
            if (BRIDGE_GATE.equals(childID)) {
                String tileName = "netherBridgeGate";
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            if (BRIDGE_CROSS.equals(childID) || START.equals(childID)) {
                String tileName = "netherBridge";
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            if (TOWER.equals(childID)) {
                String tileName = "netherTower";
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            if (ENTRANCE.equals(childID)) {
                String tileName = "netherHall";
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            if (WART_STAIRS.equals(childID)) {
                String tileName = "netherFortStairs";
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            if (THRONE.equals(childID)) {
                String tileName = "netherThrone";
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            String tileName = "netherWall";
            if (!StructureWatcherFortress.noTileAt(world, chunkX3, chunkZ)) continue;
            AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
        }
    }

    private static boolean noTileAt(World world, int chunkX, int chunkZ) {
        return AntiqueAtlasMod.extBiomeData.getData().getBiomeIdAt(world.field_73011_w.getDimension(), chunkX, chunkZ) == -1;
    }
}

