/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import hunternif.mc.atlas.core.BiomeDetectorBase;
import hunternif.mc.atlas.core.IBiomeDetector;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import hunternif.mc.atlas.util.ByteUtil;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.block.Block;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;

public class BiomeDetectorNether
extends BiomeDetectorBase
implements IBiomeDetector {
    private static final int airProbeLevel = 50;
    private static final int lavaSeaLevel = 31;
    private static final int priorityLava = 1;

    @Override
    public int getBiomeID(Chunk chunk) {
        int[] chunkBiomes;
        int biomesCount = Biome.field_185377_q.func_148742_b().size();
        try {
            chunkBiomes = ByteUtil.unsignedByteToIntArray(biomeArrayMethod.invoke((Object)chunk, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        int[] biomeOccurrences = new int[biomesCount];
        int lavaOccurences = 0;
        int groundOccurences = 0;
        int hellID = Biome.func_185362_a((Biome)Biomes.field_76778_j);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int biomeID = chunkBiomes[x << 4 | z];
                if (biomeID == hellID) {
                    Block netherBlock = chunk.func_186032_a(x, 31, z).func_177230_c();
                    if (netherBlock == Blocks.field_150353_l) {
                        ++lavaOccurences;
                        continue;
                    }
                    netherBlock = chunk.func_186032_a(x, 50, z).func_177230_c();
                    if (netherBlock == null || netherBlock == Blocks.field_150350_a) {
                        ++groundOccurences;
                        continue;
                    }
                    int n = biomeID;
                    biomeOccurrences[n] = biomeOccurrences[n] + 1;
                    continue;
                }
                if (biomeID < 0 || biomeID >= biomesCount || Biome.func_185357_a((int)biomeID) == null) continue;
                int n = biomeID;
                biomeOccurrences[n] = biomeOccurrences[n] + this.priorityForBiome(Biome.func_185357_a((int)biomeID));
            }
        }
        int meanBiomeId = -1;
        int meanBiomeOccurences = 0;
        for (int i = 0; i < biomeOccurrences.length; ++i) {
            if (biomeOccurrences[i] <= meanBiomeOccurences) continue;
            meanBiomeId = i;
            meanBiomeOccurences = biomeOccurrences[i];
        }
        if (meanBiomeOccurences < lavaOccurences) {
            meanBiomeId = ExtTileIdMap.instance().getPseudoBiomeID("lava");
        } else if (meanBiomeOccurences < groundOccurences) {
            meanBiomeId = ExtTileIdMap.instance().getPseudoBiomeID("lavaShore");
        }
        return meanBiomeId;
    }
}

