/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas;

import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.item.ItemAtlas;
import hunternif.mc.atlas.item.ItemEmptyAtlas;
import hunternif.mc.atlas.item.RecipeAtlasCloning;
import hunternif.mc.atlas.item.RecipeAtlasCombining;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="antiqueatlas")
@GameRegistry.ObjectHolder(value="antiqueatlas")
public class RegistrarAntiqueAtlas {
    @GameRegistry.ObjectHolder(value="empty_antique_atlas")
    public static final ItemEmptyAtlas EMPTY_ATLAS = new ItemEmptyAtlas();
    @GameRegistry.ObjectHolder(value="antique_atlas")
    public static final ItemAtlas ATLAS = new ItemAtlas();

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        if (SettingsConfig.gameplay.itemNeeded) {
            event.getRegistry().register(new ItemEmptyAtlas().setRegistryName("empty_antique_atlas"));
            event.getRegistry().register(new ItemAtlas().setRegistryName("antique_atlas"));
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (SettingsConfig.gameplay.itemNeeded) {
            event.getRegistry().register(new ShapelessOreRecipe(new ResourceLocation("antiqueatlas", "atlas"), new ItemStack((Item)EMPTY_ATLAS), new Object[]{Items.field_151122_aG, Items.field_151111_aL}).setRegistryName("atlas_blank"));
            event.getRegistry().register(new RecipeAtlasCloning().setRegistryName("atlas_clone"));
            event.getRegistry().register(new RecipeAtlasCombining().setRegistryName("atlas_combine"));
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        if (SettingsConfig.gameplay.itemNeeded) {
            ModelLoader.setCustomModelResourceLocation((Item)EMPTY_ATLAS, (int)0, (ModelResourceLocation)new ModelResourceLocation(EMPTY_ATLAS.getRegistryName(), "inventory"));
            ModelLoader.setCustomMeshDefinition((Item)ATLAS, stack -> new ModelResourceLocation(ATLAS.getRegistryName(), "inventory"));
        }
    }

    @SubscribeEvent
    public static void handleMissingMapping(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            if (mapping.key.func_110623_a().equalsIgnoreCase("antiqueatlas")) {
                mapping.remap((IForgeRegistryEntry)ATLAS);
                continue;
            }
            if (!mapping.key.func_110623_a().equalsIgnoreCase("emptyantiqueatlas")) continue;
            mapping.remap((IForgeRegistryEntry)EMPTY_ATLAS);
        }
    }
}

