/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.client.render.item;

import com.cjm721.overloaded.Overloaded;
import com.cjm721.overloaded.item.ModItems;
import com.cjm721.overloaded.util.AssistMode;
import com.cjm721.overloaded.util.PlayerInteractionUtil;
import com.cjm721.overloaded.util.RenderUtil;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderMultiToolAssist {
    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (event.getDwheel() != 0 && player != null && player.func_70093_af()) {
            ItemStack stack = player.func_184614_ca();
            if (player.func_70093_af() && !stack.func_190926_b() && stack.func_77973_b() == ModItems.multiTool) {
                RenderMultiToolAssist.changeHelpMode(event.getDwheel());
                player.func_146105_b((ITextComponent)new TextComponentString("Assist Mode: " + RenderMultiToolAssist.getAssistMode().getName()), true);
                event.setCanceled(true);
            }
        }
    }

    private static void changeHelpMode(int dwheel) {
        AssistMode[] values = AssistMode.values();
        int mode = (Overloaded.cachedConfig.multiToolConfig.assistMode + Integer.signum(dwheel)) % values.length;
        if (mode < 0) {
            mode += values.length;
        }
        Overloaded.cachedConfig.multiToolConfig.assistMode = mode;
        ConfigManager.sync((String)"overloaded", (Config.Type)Config.Type.INSTANCE);
    }

    @Nonnull
    public static AssistMode getAssistMode() {
        AssistMode[] values = AssistMode.values();
        int mode = Overloaded.cachedConfig.multiToolConfig.assistMode;
        for (AssistMode assistMode : values) {
            if (assistMode.getMode() != mode) continue;
            return assistMode;
        }
        RenderMultiToolAssist.changeHelpMode(0);
        return AssistMode.NONE;
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184614_ca().func_77973_b() != ModItems.multiTool) {
            return;
        }
        RayTraceResult result = PlayerInteractionUtil.getBlockPlayerLookingAtClient((EntityPlayer)player, event.getPartialTicks());
        if (result == null) {
            return;
        }
        ItemStack stack = ModItems.multiTool.getSelectedBlockItemStack(player.func_184614_ca());
        IBlockState state = stack.func_77973_b() instanceof ItemBlock ? ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176223_P() : Blocks.field_150347_e.func_176223_P();
        switch (RenderMultiToolAssist.getAssistMode()) {
            case PLACE_PREVIEW: {
                if (stack.func_190926_b()) break;
                this.renderBlockPreview(event, (EntityPlayer)player, stack, result, state);
                break;
            }
            case REMOVE_PREVIEW: {
                this.renderRemovePreview(event, (EntityPlayer)player, result);
                break;
            }
            case BOTH_PREVIEW: {
                if (!stack.func_190926_b()) {
                    this.renderBlockPreview(event, (EntityPlayer)player, stack, result, state);
                }
                this.renderRemovePreview(event, (EntityPlayer)player, result);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderRemovePreview(RenderWorldLastEvent event, EntityPlayer player, RayTraceResult result) {
        try {
            IModel model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("overloaded", "block/remove_preview"));
            IBakedModel bakeModel = model.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
            BlockPos toRenderAt = result.func_178782_a();
            float partialTicks = event.getPartialTicks();
            double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
            double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
            double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)toRenderAt.func_177958_n() - x), (double)((double)toRenderAt.func_177956_o() - y), (double)((double)toRenderAt.func_177952_p() - z));
            RenderUtil.renderGhostModel(bakeModel, Blocks.field_150347_e.func_176223_P(), player.func_130014_f_(), toRenderAt);
            GlStateManager.func_179121_F();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderBlockPreview(RenderWorldLastEvent event, EntityPlayer player, ItemStack stack, RayTraceResult result, IBlockState state) {
        BlockPos toRenderAt = result.func_178782_a().func_177971_a(result.field_178784_b.func_176730_m());
        float partialTicks = event.getPartialTicks();
        double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)toRenderAt.func_177958_n() - x), (double)((double)toRenderAt.func_177956_o() - y), (double)((double)toRenderAt.func_177952_p() - z));
        RenderUtil.renderGhostModel(stack, state, player.func_130014_f_(), toRenderAt);
        GlStateManager.func_179121_F();
    }
}

