/*
 * Decompiled with CFR 0.152.
 */
package QuantumStorage.tiles;

import QuantumStorage.config.ConfigQuantumStorage;
import QuantumStorage.init.ModBlocks;
import QuantumStorage.init.ModItems;
import QuantumStorage.inventory.slot.SlotCrate;
import QuantumStorage.inventory.slot.SlotOutputItemHandler;
import QuantumStorage.items.ItemCrate;
import QuantumStorage.tiles.AdvancedTileEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import reborncore.common.util.RebornCraftingHelper;

public class TileCrater
extends AdvancedTileEntity
implements ITickable {
    int progress = 0;

    public TileCrater() {
        this.inv = new ItemStackHandler(3);
    }

    public void func_73660_a() {
        if (this.canWork()) {
            ++this.progress;
            if (this.progress >= 100) {
                ItemStack copy = this.getInv().getStackInSlot(1).func_77946_l();
                ItemStack blankCrate = new ItemStack(ModItems.CRATE, 1);
                NBTTagCompound compound = new NBTTagCompound();
                copy.func_77955_b(compound);
                blankCrate.func_77982_d(compound);
                this.getInv().getStackInSlot(0).func_190918_g(1);
                this.getInv().setStackInSlot(1, ItemStack.field_190927_a);
                this.getInv().setStackInSlot(2, blankCrate);
                this.progress = 0;
            }
            this.sync();
        }
    }

    public boolean canWork() {
        return !this.getInv().getStackInSlot(0).func_190926_b() && this.getInv().getStackInSlot(0).func_77973_b() instanceof ItemCrate && !this.getInv().getStackInSlot(0).func_77942_o() && this.getInv().getStackInSlot(2).func_190926_b() && !this.getInv().getStackInSlot(1).func_190926_b() && this.getInv().getStackInSlot(1).func_190916_E() == this.getInv().getStackInSlot(1).func_77976_d() && !(this.getInv().getStackInSlot(1).func_77973_b() instanceof ItemCrate);
    }

    @Override
    public String getName() {
        return "crater";
    }

    @Override
    public List<Slot> getSlots() {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        slots.add((Slot)new SlotCrate((IItemHandler)this.getInv(), 0, 40, 40));
        slots.add((Slot)new SlotItemHandler((IItemHandler)this.getInv(), 1, 60, 40));
        slots.add((Slot)new SlotOutputItemHandler((IItemHandler)this.getInv(), 2, 120, 40));
        return slots;
    }

    @Override
    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileCrater();
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.openGui(playerIn, (AdvancedTileEntity)worldIn.func_175625_s(pos));
        return true;
    }

    @Override
    public Block getBlock() {
        return ModBlocks.CRATER;
    }

    @Override
    public void addRecipe() {
        if (!ConfigQuantumStorage.disableCrateingMachine) {
            RebornCraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.CRATER), (Object[])new Object[]{"IXI", "ICI", "IPI", Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('P'), new ItemStack((Block)Blocks.field_150331_J), Character.valueOf('X'), new ItemStack(ModItems.CRATE), Character.valueOf('C'), "chest"});
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawGuiContainerForegroundLayer(int mouseX, int mouseY, GuiContainer gui, int guiLeft, int guiTop) {
        super.drawGuiContainerForegroundLayer(mouseX, mouseY, gui, guiLeft, guiTop);
        this.getBuilder().drawProgressBar(gui, this.progress, 100, 90, 42, mouseX - guiLeft, mouseY - guiTop);
        this.getBuilder().drawString((GuiScreen)gui, TextFormatting.BLACK + "Crating Machine", 50, 5);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.getInv().deserializeNBT(compound);
        this.progress = compound.func_74762_e("progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_179237_a(this.getInv().serializeNBT());
        compound.func_74768_a("progress", this.progress);
        return compound;
    }
}

