/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.gamestages.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.darkhax.bookshelf.util.NBTUtils;
import net.darkhax.gamestages.data.IStageData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class StageData
implements IStageData {
    public static final String TAG_STAGES = "Stages";
    private final Set<String> unlockedStages = new HashSet<String>();

    @Override
    public Collection<String> getStages() {
        return Collections.unmodifiableCollection(this.unlockedStages);
    }

    @Override
    public boolean hasStage(String stage) {
        return this.unlockedStages.contains(stage.toLowerCase());
    }

    @Override
    public void addStage(String stage) {
        this.unlockedStages.add(stage.toLowerCase());
    }

    @Override
    public void removeStage(String stage) {
        this.unlockedStages.remove(stage.toLowerCase());
    }

    @Override
    public void clear() {
        this.unlockedStages.clear();
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        Collection stages = NBTUtils.readCollection(new ArrayList(), (NBTTagList)tag.func_150295_c(TAG_STAGES, 8), stage -> stage);
        for (String stage2 : stages) {
            this.addStage(stage2);
        }
    }

    @Override
    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(TAG_STAGES, (NBTBase)NBTUtils.writeCollection(this.getStages(), stage -> stage));
        return tag;
    }
}

