/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.storage;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.jvm.internal.impl.storage.CacheWithNotNullValues;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNotNull;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNullable;
import kotlin.reflect.jvm.internal.impl.storage.NoLock;
import kotlin.reflect.jvm.internal.impl.storage.NotNullLazyValue;
import kotlin.reflect.jvm.internal.impl.storage.NullableLazyValue;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.utils.ExceptionUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.WrappedValues;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LockBasedStorageManager
implements StorageManager {
    private static final String PACKAGE_NAME = StringsKt.substringBeforeLast(LockBasedStorageManager.class.getCanonicalName(), ".", "");
    public static final StorageManager NO_LOCKS = new LockBasedStorageManager("NO_LOCKS", ExceptionHandlingStrategy.THROW, NoLock.INSTANCE){

        @Override
        @NotNull
        protected <T> RecursionDetectedResult<T> recursionDetectedDefault() {
            return RecursionDetectedResult.fallThrough();
        }
    };
    protected final Lock lock;
    private final ExceptionHandlingStrategy exceptionHandlingStrategy;
    private final String debugText;

    private LockBasedStorageManager(@NotNull String debugText, @NotNull ExceptionHandlingStrategy exceptionHandlingStrategy, @NotNull Lock lock) {
        this.lock = lock;
        this.exceptionHandlingStrategy = exceptionHandlingStrategy;
        this.debugText = debugText;
    }

    public LockBasedStorageManager() {
        this(LockBasedStorageManager.defaultDebugName(), ExceptionHandlingStrategy.THROW, new ReentrantLock());
    }

    private static String defaultDebugName() {
        return "<unknown creating class>";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + " (" + this.debugText + ")";
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNotNull<K, V> createMemoizedFunction(@NotNull Function1<? super K, ? extends V> compute) {
        return this.createMemoizedFunction(compute, LockBasedStorageManager.<K>createConcurrentHashMap());
    }

    @NotNull
    public <K, V> MemoizedFunctionToNotNull<K, V> createMemoizedFunction(@NotNull Function1<? super K, ? extends V> compute, @NotNull ConcurrentMap<K, Object> map2) {
        return new MapBasedMemoizedFunctionToNotNull<K, V>(this, map2, compute);
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNullable<K, V> createMemoizedFunctionWithNullableValues(@NotNull Function1<? super K, ? extends V> compute) {
        return this.createMemoizedFunctionWithNullableValues(compute, LockBasedStorageManager.<K>createConcurrentHashMap());
    }

    @NotNull
    public <K, V> MemoizedFunctionToNullable<K, V> createMemoizedFunctionWithNullableValues(@NotNull Function1<? super K, ? extends V> compute, @NotNull ConcurrentMap<K, Object> map2) {
        return new MapBasedMemoizedFunction<K, V>(this, map2, compute);
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createLazyValue(@NotNull Function0<? extends T> computable) {
        return new LockBasedNotNullLazyValue<T>(this, computable);
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createRecursionTolerantLazyValue(@NotNull Function0<? extends T> computable, final @NotNull T onRecursiveCall) {
        return new LockBasedNotNullLazyValue<T>(this, computable){

            @Override
            @NotNull
            protected RecursionDetectedResult<T> recursionDetected(boolean firstTime) {
                return RecursionDetectedResult.value(onRecursiveCall);
            }
        };
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createLazyValueWithPostCompute(@NotNull Function0<? extends T> computable, final Function1<? super Boolean, ? extends T> onRecursiveCall, final @NotNull Function1<? super T, Unit> postCompute) {
        return new LockBasedNotNullLazyValue<T>(this, computable){

            @Override
            @NotNull
            protected RecursionDetectedResult<T> recursionDetected(boolean firstTime) {
                if (onRecursiveCall == null) {
                    return super.recursionDetected(firstTime);
                }
                return RecursionDetectedResult.value(onRecursiveCall.invoke(firstTime));
            }

            @Override
            protected void postCompute(@NotNull T value) {
                postCompute.invoke(value);
            }
        };
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createNullableLazyValue(@NotNull Function0<? extends T> computable) {
        return new LockBasedLazyValue<T>(this, computable);
    }

    @NotNull
    private static <K> ConcurrentMap<K, Object> createConcurrentHashMap() {
        return new ConcurrentHashMap(3, 1.0f, 2);
    }

    @NotNull
    protected <T> RecursionDetectedResult<T> recursionDetectedDefault() {
        throw LockBasedStorageManager.sanitizeStackTrace(new IllegalStateException("Recursive call in a lazy value under " + this));
    }

    @NotNull
    private static <T extends Throwable> T sanitizeStackTrace(@NotNull T throwable) {
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        int size = stackTrace.length;
        int firstNonStorage = -1;
        for (int i = 0; i < size; ++i) {
            if (stackTrace[i].getClassName().startsWith(PACKAGE_NAME)) continue;
            firstNonStorage = i;
            break;
        }
        assert (firstNonStorage >= 0) : "This method should only be called on exceptions created in LockBasedStorageManager";
        List<StackTraceElement> list = Arrays.asList(stackTrace).subList(firstNonStorage, size);
        throwable.setStackTrace(list.toArray(new StackTraceElement[list.size()]));
        return throwable;
    }

    @Override
    @NotNull
    public <K, V> CacheWithNotNullValues<K, V> createCacheWithNotNullValues() {
        return new CacheWithNotNullValuesBasedOnMemoizedFunction(this, (ConcurrentMap)LockBasedStorageManager.<K>createConcurrentHashMap());
    }

    private static class KeyWithComputation<K, V> {
        private final K key;
        private final Function0<? extends V> computation;

        public KeyWithComputation(K key, Function0<? extends V> computation) {
            this.key = key;
            this.computation = computation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyWithComputation that = (KeyWithComputation)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    private static class CacheWithNotNullValuesBasedOnMemoizedFunction<K, V>
    extends CacheWithNullableValuesBasedOnMemoizedFunction<K, V>
    implements CacheWithNotNullValues<K, V> {
        private CacheWithNotNullValuesBasedOnMemoizedFunction(@NotNull LockBasedStorageManager storageManager, @NotNull ConcurrentMap<KeyWithComputation<K, V>, Object> map2) {
            super(storageManager, map2);
        }

        @Override
        @NotNull
        public V computeIfAbsent(K key, @NotNull Function0<? extends V> computation) {
            V result2 = super.computeIfAbsent(key, computation);
            assert (result2 != null) : "computeIfAbsent() returned null under " + this.getStorageManager();
            return result2;
        }
    }

    private static class CacheWithNullableValuesBasedOnMemoizedFunction<K, V>
    extends MapBasedMemoizedFunction<KeyWithComputation<K, V>, V> {
        private CacheWithNullableValuesBasedOnMemoizedFunction(@NotNull LockBasedStorageManager storageManager, @NotNull ConcurrentMap<KeyWithComputation<K, V>, Object> map2) {
            super(storageManager, map2, new Function1<KeyWithComputation<K, V>, V>(){

                @Override
                public V invoke(KeyWithComputation<K, V> computation) {
                    return computation.computation.invoke();
                }
            });
        }

        @Nullable
        public V computeIfAbsent(K key, @NotNull Function0<? extends V> computation) {
            return this.invoke(new KeyWithComputation<K, V>(key, computation));
        }
    }

    private static class MapBasedMemoizedFunctionToNotNull<K, V>
    extends MapBasedMemoizedFunction<K, V>
    implements MemoizedFunctionToNotNull<K, V> {
        public MapBasedMemoizedFunctionToNotNull(@NotNull LockBasedStorageManager storageManager, @NotNull ConcurrentMap<K, Object> map2, @NotNull Function1<? super K, ? extends V> compute) {
            super(storageManager, map2, compute);
        }

        @Override
        @NotNull
        public V invoke(K input) {
            Object result2 = super.invoke(input);
            assert (result2 != null) : "compute() returned null under " + this.getStorageManager();
            return result2;
        }
    }

    private static class MapBasedMemoizedFunction<K, V>
    implements MemoizedFunctionToNullable<K, V> {
        private final LockBasedStorageManager storageManager;
        private final ConcurrentMap<K, Object> cache;
        private final Function1<? super K, ? extends V> compute;

        public MapBasedMemoizedFunction(@NotNull LockBasedStorageManager storageManager, @NotNull ConcurrentMap<K, Object> map2, @NotNull Function1<? super K, ? extends V> compute) {
            this.storageManager = storageManager;
            this.cache = map2;
            this.compute = compute;
        }

        @Override
        @Nullable
        public V invoke(K input) {
            Object value = this.cache.get(input);
            if (value != null && value != NotValue.COMPUTING) {
                return WrappedValues.unescapeExceptionOrNull(value);
            }
            this.storageManager.lock.lock();
            try {
                V v;
                value = this.cache.get(input);
                if (value == NotValue.COMPUTING) {
                    throw this.recursionDetected(input);
                }
                if (value != null) {
                    Object v2 = WrappedValues.unescapeExceptionOrNull(value);
                    return v2;
                }
                AssertionError error = null;
                try {
                    this.cache.put(input, (Object)NotValue.COMPUTING);
                    V typedValue = this.compute.invoke(input);
                    Object oldValue = this.cache.put(input, WrappedValues.escapeNull(typedValue));
                    if (oldValue != NotValue.COMPUTING) {
                        error = this.raceCondition(input, oldValue);
                        throw error;
                    }
                    v = typedValue;
                }
                catch (Throwable throwable) {
                    if (ExceptionUtilsKt.isProcessCanceledException(throwable)) {
                        this.cache.remove(input);
                        throw (RuntimeException)throwable;
                    }
                    if (throwable == error) {
                        throw this.storageManager.exceptionHandlingStrategy.handleException(throwable);
                    }
                    Object oldValue = this.cache.put(input, WrappedValues.escapeThrowable(throwable));
                    if (oldValue != NotValue.COMPUTING) {
                        throw this.raceCondition(input, oldValue);
                    }
                    throw this.storageManager.exceptionHandlingStrategy.handleException(throwable);
                }
                return v;
            }
            finally {
                this.storageManager.lock.unlock();
            }
        }

        @NotNull
        private AssertionError recursionDetected(K input) {
            return (AssertionError)((Object)LockBasedStorageManager.sanitizeStackTrace((Throwable)((Object)new AssertionError((Object)("Recursion detected on input: " + input + " under " + this.storageManager)))));
        }

        @NotNull
        private AssertionError raceCondition(K input, Object oldValue) {
            return (AssertionError)((Object)LockBasedStorageManager.sanitizeStackTrace((Throwable)((Object)new AssertionError((Object)("Race condition detected on input " + input + ". Old value is " + oldValue + " under " + this.storageManager)))));
        }

        protected LockBasedStorageManager getStorageManager() {
            return this.storageManager;
        }
    }

    private static class LockBasedNotNullLazyValue<T>
    extends LockBasedLazyValue<T>
    implements NotNullLazyValue<T> {
        public LockBasedNotNullLazyValue(@NotNull LockBasedStorageManager storageManager, @NotNull Function0<? extends T> computable) {
            super(storageManager, computable);
        }

        @Override
        @NotNull
        public T invoke() {
            Object result2 = super.invoke();
            assert (result2 != null) : "compute() returned null";
            return result2;
        }
    }

    private static class LockBasedLazyValue<T>
    implements NullableLazyValue<T> {
        private final LockBasedStorageManager storageManager;
        private final Function0<? extends T> computable;
        @Nullable
        private volatile Object value = NotValue.NOT_COMPUTED;

        public LockBasedLazyValue(@NotNull LockBasedStorageManager storageManager, @NotNull Function0<? extends T> computable) {
            this.storageManager = storageManager;
            this.computable = computable;
        }

        public boolean isComputed() {
            return this.value != NotValue.NOT_COMPUTED && this.value != NotValue.COMPUTING;
        }

        @Override
        public T invoke() {
            Object _value = this.value;
            if (!(_value instanceof NotValue)) {
                return (T)WrappedValues.unescapeThrowable(_value);
            }
            this.storageManager.lock.lock();
            try {
                T t;
                RecursionDetectedResult<T> result2;
                _value = this.value;
                if (!(_value instanceof NotValue)) {
                    Object v = WrappedValues.unescapeThrowable(_value);
                    return (T)v;
                }
                if (_value == NotValue.COMPUTING) {
                    this.value = NotValue.RECURSION_WAS_DETECTED;
                    result2 = this.recursionDetected(true);
                    if (!result2.isFallThrough()) {
                        T t2 = result2.getValue();
                        return t2;
                    }
                }
                if (_value == NotValue.RECURSION_WAS_DETECTED && !(result2 = this.recursionDetected(false)).isFallThrough()) {
                    T t3 = result2.getValue();
                    return t3;
                }
                this.value = NotValue.COMPUTING;
                try {
                    T typedValue = this.computable.invoke();
                    this.value = typedValue;
                    this.postCompute(typedValue);
                    t = typedValue;
                }
                catch (Throwable throwable) {
                    if (ExceptionUtilsKt.isProcessCanceledException(throwable)) {
                        this.value = NotValue.NOT_COMPUTED;
                        throw (RuntimeException)throwable;
                    }
                    if (this.value == NotValue.COMPUTING) {
                        this.value = WrappedValues.escapeThrowable(throwable);
                    }
                    throw this.storageManager.exceptionHandlingStrategy.handleException(throwable);
                }
                return t;
            }
            finally {
                this.storageManager.lock.unlock();
            }
        }

        @NotNull
        protected RecursionDetectedResult<T> recursionDetected(boolean firstTime) {
            return this.storageManager.recursionDetectedDefault();
        }

        protected void postCompute(T value) {
        }
    }

    private static enum NotValue {
        NOT_COMPUTED,
        COMPUTING,
        RECURSION_WAS_DETECTED;

    }

    private static class RecursionDetectedResult<T> {
        private final T value;
        private final boolean fallThrough;

        @NotNull
        public static <T> RecursionDetectedResult<T> value(T value) {
            return new RecursionDetectedResult<T>(value, false);
        }

        @NotNull
        public static <T> RecursionDetectedResult<T> fallThrough() {
            return new RecursionDetectedResult<Object>(null, true);
        }

        private RecursionDetectedResult(T value, boolean fallThrough) {
            this.value = value;
            this.fallThrough = fallThrough;
        }

        public T getValue() {
            assert (!this.fallThrough) : "A value requested from FALL_THROUGH in " + this;
            return this.value;
        }

        public boolean isFallThrough() {
            return this.fallThrough;
        }

        public String toString() {
            return this.isFallThrough() ? "FALL_THROUGH" : String.valueOf(this.value);
        }
    }

    public static interface ExceptionHandlingStrategy {
        public static final ExceptionHandlingStrategy THROW = new ExceptionHandlingStrategy(){

            @Override
            @NotNull
            public RuntimeException handleException(@NotNull Throwable throwable) {
                throw ExceptionUtilsKt.rethrow(throwable);
            }
        };

        @NotNull
        public RuntimeException handleException(@NotNull Throwable var1);
    }
}

