/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.command.help;

import codechicken.lib.command.help.IBetterHelpCommand;
import codechicken.lib.command.help.IHelpCommandHost;
import codechicken.lib.command.help.IHelpPage;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class HelpCommandBase
extends CommandBase {
    private IHelpCommandHost host;
    private List<IHelpPage> helpPages;

    public HelpCommandBase(IHelpCommandHost host) {
        this.host = host;
        this.helpPages = new LinkedList<IHelpPage>();
    }

    public HelpCommandBase addHelpPage(IHelpPage page) {
        this.helpPages.add(page);
        return this;
    }

    public int func_82362_a() {
        return 0;
    }

    public String func_71517_b() {
        return "help";
    }

    public String func_71518_a(ICommandSender sender) {
        return "Displays help for /" + this.host.getParentName() + " commands.";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            this.displayHelp(server, sender);
        } else if (args.length == 1) {
            String arg = args[0];
            if (this.host.getSubCommandMap().containsKey(arg)) {
                ICommand subCommand = this.host.getSubCommandMap().get(arg);
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Help for: /" + this.host.getParentName() + " " + arg));
                if (subCommand instanceof IBetterHelpCommand) {
                    for (String line : ((IBetterHelpCommand)subCommand).getHelp()) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + line));
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + subCommand.func_71518_a(sender)));
                }
            } else {
                for (IHelpPage page : this.helpPages) {
                    if (!page.getName().equals(arg)) continue;
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Displaying Help Page: " + arg));
                    for (String line : page.getHelp()) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.BLUE + line));
                    }
                    return;
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "No Sub Command or Help Page exists for \"" + arg + "\"!"));
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Too many arguments!"));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            List keys = this.host.getSubCommandMap().values().stream().filter(p -> p.func_184882_a(server, sender)).map(ICommand::func_71517_b).collect(Collectors.toList());
            keys.addAll(this.helpPages.stream().map(IHelpPage::getName).collect(Collectors.toList()));
            keys.sort(null);
            return HelpCommandBase.func_175762_a((String[])args, keys);
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }

    public void displayHelp(MinecraftServer server, ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_GREEN + "Available commands for /" + this.host.getParentName() + ":"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "For more info use \"/" + this.host.getParentName() + " help [command]\""));
        for (Map.Entry<String, ICommand> entry : this.host.getSubCommandMap().entrySet()) {
            String prefix = "";
            if (!entry.getValue().func_184882_a(server, sender)) {
                prefix = TextFormatting.RED.toString();
            }
            sender.func_145747_a((ITextComponent)new TextComponentString(prefix + "/" + this.host.getParentName() + " " + TextFormatting.YELLOW + entry.getValue().func_71517_b() + TextFormatting.BLUE + " " + HelpCommandBase.getCommandBrief(entry.getValue(), sender)));
        }
        for (IHelpPage page : this.helpPages) {
            sender.func_145747_a((ITextComponent)new TextComponentString("/" + this.host.getParentName() + TextFormatting.YELLOW + " help " + page.getName() + TextFormatting.BLUE + " " + page.getDesc()));
        }
    }

    private static String getCommandBrief(ICommand command, ICommandSender sender) {
        if (command instanceof IBetterHelpCommand) {
            return ((IBetterHelpCommand)command).getDesc();
        }
        return command.func_71518_a(sender);
    }
}

