/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature.item;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.cucumber.item.ItemMeta;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.pickletweaks.PickleTweaks;
import com.blakebr0.pickletweaks.config.ModConfig;
import com.blakebr0.pickletweaks.feature.crafting.GridRepairHelper;
import com.blakebr0.pickletweaks.registry.ModItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;

public class ItemRepairKit
extends ItemMeta
implements IEnableable {
    public static Map<Integer, Kit> kits = new HashMap<Integer, Kit>();
    private Configuration config = ModConfig.config;

    public ItemRepairKit() {
        super("pt.repair_kit", PickleTweaks.REGISTRY);
        this.func_77637_a(PickleTweaks.CREATIVE_TAB);
    }

    public String func_77653_i(ItemStack stack) {
        String name = this.items.containsKey(stack.func_77960_j()) ? ((ItemMeta.MetaItem)this.items.get(stack.func_77960_j())).getName() : "dummy";
        return Utils.localize((String)("kit.pt." + name)) + " " + Utils.localize((String)"item.pt.repair_kit.name");
    }

    public void init() {
        this.addKit(new Kit(0, "wood", 7033119, new ItemStack(Blocks.field_150344_f, 1, Short.MAX_VALUE)));
        this.addKit(new Kit(1, "stone", 0x7F7F7F, new ItemStack(Blocks.field_150347_e)));
        this.addKit(new Kit(2, "iron", 0xC1C1C1, "ingotIron"));
        this.addKit(new Kit(3, "gold", 12369741, "ingotGold"));
        this.addKit(new Kit(4, "diamond", 2601626, "gemDiamond"));
        this.addKit(new Kit(5, "flint", 0x565656, new ItemStack(Items.field_151145_ak)));
        this.addKit(new Kit(12, "aluminum", 13553369, "ingotAluminum"));
        this.addKit(new Kit(13, "copper", 16360014, "ingotCopper"));
        this.addKit(new Kit(14, "tin", 10731736, "ingotTin"));
        this.addKit(new Kit(15, "bronze", 15312482, "ingotBronze"));
        this.addKit(new Kit(16, "lead", 11582168, "ingotLead"));
        this.addKit(new Kit(17, "silver", 10732234, "ingotSilver"));
        this.addKit(new Kit(18, "nickel", 13155715, "ingotNickel"));
        this.addKit(new Kit(19, "invar", 11845821, "ingotInvar"));
        this.addKit(new Kit(20, "constantan", 14922604, "ingotConstantan"));
        this.addKit(new Kit(21, "electrum", 14139219, "ingotElectrum"));
        this.addKit(new Kit(22, "steel", 0x858585, "ingotSteel"));
        this.addKit(new Kit(23, "platinum", 7132668, "ingotPlatinum"));
    }

    public void initModels() {
        for (Map.Entry item : this.items.entrySet()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)((Integer)item.getKey()), (ModelResourceLocation)new ModelResourceLocation("pickletweaks:repair_kit", "inventory"));
        }
    }

    public static void initRecipes() {
        if (!ModConfig.confRepairKits || !ModConfig.confHammer) {
            return;
        }
        for (Map.Entry<Integer, Kit> kit : kits.entrySet()) {
            String ore;
            Kit kitten = kit.getValue();
            Object rep = kitten.representative;
            if (rep instanceof ItemStack) {
                ItemStack stack = (ItemStack)rep;
                if (stack.func_190926_b()) continue;
                RecipeHelper.addShapedRecipe((ItemStack)new ItemStack((Item)ModItems.itemRepairKit, 2, kit.getKey().intValue()), (Object[])new Object[]{"SMS", "MHM", "SMS", Character.valueOf('S'), "stickWood", Character.valueOf('M'), stack, Character.valueOf('H'), StackHelper.to((Object)((Object)ModItems.itemHammer), (int)1, (int)Short.MAX_VALUE)});
                continue;
            }
            if (!(rep instanceof String) || !OreDictionary.doesOreNameExist((String)(ore = (String)rep))) continue;
            RecipeHelper.addShapedRecipe((ItemStack)new ItemStack((Item)ModItems.itemRepairKit, 2, kit.getKey().intValue()), (Object[])new Object[]{"SMS", "MHM", "SMS", Character.valueOf('S'), "stickWood", Character.valueOf('M'), ore, Character.valueOf('H'), StackHelper.to((Object)((Object)ModItems.itemHammer), (int)1, (int)Short.MAX_VALUE)});
        }
    }

    public ItemStack addKit(Kit kit) {
        return this.addKit(kit, true);
    }

    public ItemStack addKit(Kit kit, boolean also) {
        boolean enabled;
        boolean bl = enabled = this.config.get("repair_kit", kit.name, true).getBoolean() && also;
        if (enabled) {
            kits.put(kit.meta, kit);
        }
        return this.addItem(kit.meta, kit.name, enabled);
    }

    public Kit getKit(ItemStack stack) {
        return kits.get(stack.func_77960_j());
    }

    public boolean isEnabled() {
        return ModConfig.confRepairKits;
    }

    public static boolean isKitValid(ItemStack tool, Kit kit) {
        Object rep = kit.representative;
        if (rep instanceof String) {
            String ore = (String)rep;
            if (OreDictionary.doesOreNameExist((String)ore)) {
                return OreDictionary.getOres((String)ore).stream().anyMatch(repair -> GridRepairHelper.checkMaterial(tool, repair));
            }
        } else if (rep instanceof ItemStack) {
            ItemStack stack = (ItemStack)rep;
            return GridRepairHelper.checkMaterial(tool, stack);
        }
        return false;
    }

    public static class Kit {
        public int meta;
        public String name;
        public int color;
        public Object representative;

        public Kit(int meta, String name, int color, Object representative) {
            this.meta = meta;
            this.name = name;
            this.color = color;
            this.representative = representative;
        }
    }
}

