/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.api.upgrade;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import gr8pefish.ironbackpacks.api.IronBackpacksAPI;
import gr8pefish.ironbackpacks.api.ModifyMethod;
import gr8pefish.ironbackpacks.api.backpack.BackpackInfo;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class BackpackUpgrade
extends IForgeRegistryEntry.Impl<BackpackUpgrade> {
    private final ResourceLocation identifier;
    private final int applicationCost;
    private final int minimumTier;
    private final Set<BackpackUpgrade> conflicting;
    private int maxApplications = 1;

    public BackpackUpgrade(@Nonnull ResourceLocation identifier, int applicationCost, @Nonnegative int minimumTier) {
        Preconditions.checkNotNull((Object)identifier, (Object)"Identifier cannot be null");
        Preconditions.checkArgument((minimumTier >= 0 ? 1 : 0) != 0, (Object)"Minimum tier cannot be negative");
        this.applicationCost = applicationCost;
        this.minimumTier = minimumTier;
        this.identifier = identifier;
        this.conflicting = Sets.newHashSet();
        this.setRegistryName(identifier);
    }

    public void onInventory(@Nonnull ModifyMethod method, @Nonnull ItemStack stack, @Nonnull EntityPlayer player, @Nonnull BackpackInfo backpackInfo) {
    }

    public final int getApplicationCost() {
        return this.applicationCost;
    }

    @Nonnegative
    public final int getMinimumTier() {
        return this.minimumTier;
    }

    @Nonnull
    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public boolean isConflicting(@Nullable BackpackUpgrade backpackUpgrade) {
        return backpackUpgrade == null || this.conflicting.contains((Object)backpackUpgrade);
    }

    @Nonnull
    public BackpackUpgrade addConflicting(@Nonnull BackpackUpgrade backpackUpgrade) {
        Preconditions.checkNotNull((Object)((Object)backpackUpgrade), (Object)"BackpackUpgrade cannot be null");
        this.conflicting.add(backpackUpgrade);
        return this;
    }

    public BackpackUpgrade withMaxApplications(int maxApplications) {
        this.maxApplications = maxApplications;
        return this;
    }

    public int getMaxApplications() {
        return this.maxApplications;
    }

    public boolean isNull() {
        return this.getIdentifier().equals((Object)IronBackpacksAPI.NULL);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("identifier", (Object)this.identifier).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackpackUpgrade)) {
            return false;
        }
        BackpackUpgrade that = (BackpackUpgrade)((Object)o);
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }
}

