/*
 * Decompiled with CFR 0.152.
 */
package genandnic.walljump.client;

import genandnic.walljump.WallJumpConfig;
import genandnic.walljump.client.FallingSound;
import genandnic.walljump.client.PlayerDoubleJump;
import genandnic.walljump.client.PlayerSpeedBoost;
import genandnic.walljump.client.PlayerWallJump;
import genandnic.walljump.common.CommonProxy;
import genandnic.walljump.common.packet.PacketForceConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ClientListener {
    private static Minecraft minecraft = Minecraft.func_71410_x();
    private static FallingSound fallingSound;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ClientListener.minecraft.field_71439_g != null) {
            float f;
            EntityPlayerSP player = ClientListener.minecraft.field_71439_g;
            PlayerSpeedBoost.applySpeedBoost(player);
            PlayerWallJump.tryWallJump(player);
            PlayerDoubleJump.tryDoubleJump(player);
            if ((fallingSound == null || fallingSound.func_147667_k()) && (double)(f = MathHelper.func_76133_a((double)(player.field_70159_w * player.field_70159_w + player.field_70179_y * player.field_70179_y + player.field_70181_x * player.field_70181_x)) - 0.5f) > 0.25) {
                fallingSound = new FallingSound(player);
                minecraft.func_147118_V().func_147682_a((ISound)fallingSound);
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (fallingSound != null && event.getWorld().field_72995_K) {
            fallingSound.setDonePlaying();
            fallingSound = null;
        }
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("walljump")) {
            ConfigManager.sync((String)"walljump", (Config.Type)Config.Type.INSTANCE);
            WallJumpConfig.loadLocalConfig();
            if (minecraft.func_71387_A()) {
                CommonProxy.NETWORK.sendToAll((IMessage)new PacketForceConfig());
            }
        }
    }

    @SubscribeEvent
    public void onInitGUIEvent(GuiScreenEvent.InitGuiEvent.Post event) {
        if (WallJumpConfig.isRemote && event.getGui() instanceof GuiConfig) {
            GuiConfig gui = (GuiConfig)event.getGui();
            if (gui.modID.equals("walljump")) {
                minecraft.func_147108_a(null);
                ClientListener.minecraft.field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("walljump.message.remoteConfig", new Object[0]));
            }
        }
    }

    @SubscribeEvent
    public void onClientConnect(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        WallJumpConfig.loadLocalConfig();
    }
}

