/*
 * Decompiled with CFR 0.152.
 */
package genandnic.walljump;

import genandnic.walljump.client.PlayerDoubleJump;
import genandnic.walljump.client.PlayerSpeedBoost;
import genandnic.walljump.client.PlayerWallJump;
import genandnic.walljump.common.packet.PacketForceConfig;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.config.Config;

@Config(modid="walljump")
public class WallJumpConfig {
    @Config.Ignore
    public static boolean isRemote = false;
    @Config.RangeDouble(min=3.0)
    @Config.Comment(value={"Minimum distance for fall damage; set to 3.0 to disable"})
    public static double minFallDistance = 7.5;
    @Config.Comment(value={"Allows you to wall cling and wall jump"})
    public static boolean useWallJump = true;
    @Config.Comment(value={"Allows you to climb up without alternating walls"})
    public static boolean allowReClinging = false;
    @Config.RangeDouble(min=0.5, max=1.0)
    public static double wallJumpHeight = 0.8;
    @Config.RangeDouble(min=0.01, max=1.0)
    public static double wallSlideSpeed = 0.1;
    @Config.RangeInt(min=0)
    @Config.Comment(value={"Ticks wall clinged before a wall slide"})
    public static int wallSlideDelay = 15;
    @Config.RangeDouble(min=0.0, max=1.0)
    @Config.Comment(value={"Exhaustion gained per tick wall clinging"})
    public static double exhaustionWallCling = 0.01;
    @Config.RangeDouble(min=0.0, max=3.0)
    @Config.Comment(value={"Exhaustion gained per wall jump"})
    public static double exhaustionWallJump = 0.75;
    @Config.Comment(value={"A list of blocks that cannot be clinged to"})
    public static String[] blacklistedBlocks = new String[]{"minecraft:ice", "minecraft:packed_ice"};
    @Config.Comment(value={"Turns the blacklisted block list into a whitelist"})
    public static boolean invertBlockBlacklist = false;
    @Config.Comment(value={"Allows you to jump in mid-air"})
    public static boolean useDoubleJump = false;
    @Config.RangeDouble(min=1.0, max=3.0)
    @Config.Comment(value={"Sprint speed boost; set to 1.0 to disable"})
    public static double sprintSpeedModifier = 1.0;

    public static void loadLocalConfig() {
        isRemote = false;
        PlayerWallJump.useWallJump = useWallJump;
        PlayerWallJump.allowReClinging = allowReClinging;
        PlayerWallJump.wallJumpHeight = (float)wallJumpHeight * 0.6875f;
        PlayerWallJump.wallSlideSpeed = wallSlideSpeed;
        PlayerWallJump.wallSlideDelay = wallSlideDelay;
        PlayerWallJump.blackList = Arrays.asList(blacklistedBlocks);
        PlayerWallJump.invertBlockBlacklist = invertBlockBlacklist;
        PlayerDoubleJump.useDoubleJump = useDoubleJump;
        PlayerSpeedBoost.sprintSpeedModifier = (float)(sprintSpeedModifier - 1.0) * 0.125f;
    }

    public static void loadRemoteConfig(PacketForceConfig message) {
        isRemote = !Minecraft.func_71410_x().func_71387_A();
        PlayerWallJump.useWallJump = message.useWallJump;
        PlayerWallJump.allowReClinging = message.allowReClinging;
        PlayerWallJump.wallJumpHeight = (float)message.wallJumpHeight * 0.6875f;
        PlayerWallJump.wallSlideSpeed = message.wallSlideSpeed;
        PlayerWallJump.wallSlideDelay = message.wallSlideDelay;
        PlayerDoubleJump.useDoubleJump = message.useDoubleJump;
        PlayerSpeedBoost.sprintSpeedModifier = (float)(message.sprintSpeedModifier - 1.0) * 0.125f;
    }
}

