/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe.behaviour;

import buildcraft.api.core.IStackFilter;
import buildcraft.api.inventory.IItemTransactor;
import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjRedstoneReceiver;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.api.transport.pipe.IFlowFluid;
import buildcraft.api.transport.pipe.IFlowItems;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.PipeBehaviour;
import buildcraft.api.transport.pipe.PipeEventHandler;
import buildcraft.api.transport.pipe.PipeEventItem;
import buildcraft.api.transport.pipe.PipeFlow;
import buildcraft.lib.inventory.ItemTransactorHelper;
import buildcraft.lib.inventory.filter.StackFilter;
import buildcraft.lib.misc.BoundingBoxUtil;
import buildcraft.lib.misc.VecUtil;
import java.util.List;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;

public class PipeBehaviourObsidian
extends PipeBehaviour
implements IMjRedstoneReceiver {
    private static final long POWER_PER_ITEM = MjAPI.MJ / 2L;
    private static final long POWER_PER_METRE = MjAPI.MJ / 4L;
    private static final double INSERT_SPEED = 0.04;
    private static final int DROP_GAP = 20;
    private final MjCapabilityHelper mjCaps = new MjCapabilityHelper((IMjConnector)this);
    private final WeakHashMap<EntityItem, Long> entityDropTime = new WeakHashMap();
    private int toWaitTicks = 0;

    public PipeBehaviourObsidian(IPipe pipe) {
        super(pipe);
    }

    public PipeBehaviourObsidian(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        this.toWaitTicks = 20;
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        return nbt;
    }

    public void onTick() {
        if (this.pipe.getHolder().getPipeWorld().field_72995_K) {
            return;
        }
        --this.toWaitTicks;
        if (this.toWaitTicks > 0) {
            return;
        }
        this.toWaitTicks = 0;
    }

    public boolean canConnect(EnumFacing face, PipeBehaviour other) {
        return !(other instanceof PipeBehaviourObsidian);
    }

    public void onEntityCollide(Entity entity) {
        if (this.pipe.getHolder().getPipeWorld().field_72995_K) {
            return;
        }
        EnumFacing openFace = this.getOpenFace();
        if (openFace != null) {
            this.trySuckEntity(entity, openFace, Long.MAX_VALUE, false);
        }
    }

    private EnumFacing getOpenFace() {
        EnumFacing openFace = null;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (!this.pipe.isConnected(face)) continue;
            if (openFace == null) {
                openFace = face.func_176734_d();
                continue;
            }
            return null;
        }
        return openFace;
    }

    protected AxisAlignedBB getSuckingBox(EnumFacing openFace, int distance) {
        AxisAlignedBB bb = BoundingBoxUtil.makeAround((Vec3d)VecUtil.convertCenter((Vec3i)this.pipe.getHolder().getPipePos()), (double)0.4);
        switch (openFace) {
            default: {
                return bb.func_72317_d((double)(-distance), 0.0, 0.0).func_72314_b(0.5, (double)distance, (double)distance);
            }
            case EAST: {
                return bb.func_72317_d((double)distance, 0.0, 0.0).func_72314_b(0.5, (double)distance, (double)distance);
            }
            case DOWN: {
                return bb.func_72317_d(0.0, (double)(-distance), 0.0).func_72314_b((double)distance, 0.5, (double)distance);
            }
            case UP: {
                return bb.func_72317_d(0.0, (double)distance, 0.0).func_72314_b((double)distance, 0.5, (double)distance);
            }
            case NORTH: {
                return bb.func_72317_d(0.0, 0.0, (double)(-distance)).func_72314_b((double)distance, (double)distance, 0.5);
            }
            case SOUTH: 
        }
        return bb.func_72317_d(0.0, 0.0, (double)distance).func_72314_b((double)distance, (double)distance, 0.5);
    }

    protected long trySuckEntity(Entity entity, EnumFacing faceFrom, long power, boolean simulate) {
        PipeFlow flow;
        if (entity.field_70128_L || entity instanceof EntityLivingBase) {
            return power;
        }
        Long tickPickupObj = this.entityDropTime.get(entity);
        if (tickPickupObj != null) {
            long tickPickup = tickPickupObj;
            long tickNow = this.pipe.getHolder().getPipeWorld().func_82737_E();
            if (tickNow < tickPickup) {
                return power;
            }
            this.entityDropTime.remove(entity);
        }
        IFlowItems flowItem = (flow = this.pipe.getFlow()) instanceof IFlowItems ? (IFlowItems)flow : null;
        IFlowFluid flowFluid = flow instanceof IFlowFluid ? (IFlowFluid)flow : null;
        IItemTransactor transactor = ItemTransactorHelper.getTransactorForEntity((Entity)entity, (EnumFacing)faceFrom.func_176734_d());
        if (flowItem != null) {
            long powerReqPerItem;
            int max;
            if (power == Long.MAX_VALUE) {
                max = Integer.MAX_VALUE;
                powerReqPerItem = 0L;
            } else {
                double distance = Math.sqrt(entity.func_174831_c(this.pipe.getHolder().getPipePos()));
                powerReqPerItem = (long)(Math.max(1.0, distance) * (double)POWER_PER_METRE + (double)POWER_PER_ITEM);
                max = (int)(power / powerReqPerItem);
            }
            ItemStack extracted = transactor.extract((IStackFilter)StackFilter.ALL, 1, max, simulate);
            if (!extracted.func_190926_b()) {
                if (!simulate) {
                    flowItem.insertItemsForce(extracted, faceFrom, null, 0.04);
                }
                return power - powerReqPerItem * (long)extracted.func_190916_E();
            }
        }
        if (flowFluid != null) {
            // empty if block
        }
        return power;
    }

    @PipeEventHandler
    public void onPipeDrop(PipeEventItem.Drop drop) {
        this.entityDropTime.put(drop.getEntity(), this.pipe.getHolder().getPipeWorld().func_82737_E() + 20L);
    }

    public boolean canConnect(@Nonnull IMjConnector other) {
        return true;
    }

    public long getPowerRequested() {
        long power = 512L * MjAPI.MJ;
        return power - this.receivePower(power, true);
    }

    public long receivePower(long microJoules, boolean simulate) {
        if (this.toWaitTicks > 0) {
            return microJoules;
        }
        EnumFacing openFace = this.getOpenFace();
        if (openFace == null) {
            return microJoules;
        }
        for (int d = 1; d < 5; ++d) {
            AxisAlignedBB aabb = this.getSuckingBox(openFace, d);
            List discoveredEntities = this.pipe.getHolder().getPipeWorld().func_72872_a(Entity.class, aabb);
            for (Entity entity : discoveredEntities) {
                long leftOver = this.trySuckEntity(entity, openFace, microJoules, simulate);
                if (leftOver >= microJoules) continue;
                return leftOver;
            }
        }
        return microJoules - MjAPI.MJ;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        Object cap = this.mjCaps.getCapability(capability, facing);
        if (cap != null) {
            return (T)cap;
        }
        return (T)super.getCapability(capability, facing);
    }
}

