/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.registry;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mods.waterstrainer.Config;
import mods.waterstrainer.item.ItemBaitPot;
import mods.waterstrainer.item.ItemEfficiencyMeter;
import mods.waterstrainer.item.ItemGardenTrowel;
import mods.waterstrainer.item.ItemNet;
import mods.waterstrainer.item.ItemStrainer;
import mods.waterstrainer.item.ItemSuperWorm;
import mods.waterstrainer.item.ItemWorm;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemRegistry {
    public static Map<String, Integer> model_registry = new HashMap<String, Integer>();
    public static Map<String, ItemStrainer> strainer_registry = new HashMap<String, ItemStrainer>();
    public static ItemStrainer strainer_survivalist;
    public static ItemStrainer strainer_survivalist_solid;
    public static ItemStrainer strainer_survivalist_reinforced;
    public static ItemStrainer strainer_survivalist_dense;
    public static ItemStrainer strainer_survivalist_dense_solid;
    public static ItemStrainer strainer_survivalist_dense_reinforced;
    public static ItemStrainer strainer_fisherman;
    public static ItemNet net;
    public static ItemEfficiencyMeter efficiency_meter;
    public static ItemWorm worm;
    public static ItemSuperWorm super_worm;
    public static ItemBaitPot bait_pot;
    public static ItemGardenTrowel garden_trowel;

    public static void addStrainer(ItemStrainer item, int id, List<ItemStrainer.StrainerType> types) {
        item.strainer_type = types;
        model_registry.put(item.getRegistryName().toString(), id);
        strainer_registry.put(item.getRegistryName().toString().substring("waterstrainer".length() + 1), item);
    }

    public static void resetAllLootTables() {
        for (Map.Entry<String, ItemStrainer> strainer : strainer_registry.entrySet()) {
            strainer.getValue().resetLootTable();
        }
    }

    public static int getMetaFromName(String itemName) {
        return itemName != null && model_registry.containsKey(itemName) ? model_registry.get(itemName) : 0;
    }

    @Mod.EventBusSubscriber(modid="waterstrainer")
    public static class Registration {
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            net = new ItemNet();
            registry.register((IForgeRegistryEntry)net);
            worm = new ItemWorm();
            registry.register((IForgeRegistryEntry)worm);
            super_worm = new ItemSuperWorm();
            registry.register((IForgeRegistryEntry)super_worm);
            bait_pot = new ItemBaitPot();
            registry.register((IForgeRegistryEntry)bait_pot);
            garden_trowel = new ItemGardenTrowel();
            registry.register((IForgeRegistryEntry)garden_trowel);
            efficiency_meter = new ItemEfficiencyMeter();
            registry.register((IForgeRegistryEntry)efficiency_meter);
            strainer_survivalist = new ItemStrainer("strainer_survivalist", Config.durabilityNormalStrainer);
            registry.register((IForgeRegistryEntry)strainer_survivalist);
            ItemRegistry.addStrainer(strainer_survivalist, 2, Arrays.asList(ItemStrainer.StrainerType.SURVIVAL));
            strainer_survivalist_solid = new ItemStrainer("strainer_survivalist_solid", Config.durabilitySolidStrainer);
            registry.register((IForgeRegistryEntry)strainer_survivalist_solid);
            ItemRegistry.addStrainer(strainer_survivalist_solid, 3, Arrays.asList(ItemStrainer.StrainerType.SURVIVAL, ItemStrainer.StrainerType.SOLID));
            strainer_survivalist_reinforced = new ItemStrainer("strainer_survivalist_reinforced", Config.durabilityReinforcedStrainer);
            registry.register((IForgeRegistryEntry)strainer_survivalist_reinforced);
            ItemRegistry.addStrainer(strainer_survivalist_reinforced, 4, Arrays.asList(ItemStrainer.StrainerType.SURVIVAL, ItemStrainer.StrainerType.REINFORCED));
            strainer_survivalist_dense = new ItemStrainer("strainer_survivalist_dense", Config.durabilityNormalStrainer);
            registry.register((IForgeRegistryEntry)strainer_survivalist_dense);
            ItemRegistry.addStrainer(strainer_survivalist_dense, 5, Arrays.asList(ItemStrainer.StrainerType.SURVIVAL_DENSE));
            strainer_survivalist_dense_solid = new ItemStrainer("strainer_survivalist_dense_solid", Config.durabilitySolidStrainer);
            registry.register((IForgeRegistryEntry)strainer_survivalist_dense_solid);
            ItemRegistry.addStrainer(strainer_survivalist_dense_solid, 6, Arrays.asList(ItemStrainer.StrainerType.SURVIVAL_DENSE, ItemStrainer.StrainerType.SOLID));
            strainer_survivalist_dense_reinforced = new ItemStrainer("strainer_survivalist_dense_reinforced", Config.durabilityReinforcedStrainer);
            registry.register((IForgeRegistryEntry)strainer_survivalist_dense_reinforced);
            ItemRegistry.addStrainer(strainer_survivalist_dense_reinforced, 7, Arrays.asList(ItemStrainer.StrainerType.SURVIVAL_DENSE, ItemStrainer.StrainerType.REINFORCED));
            strainer_fisherman = new ItemStrainer("strainer_fisherman", Config.durabilityFishermansStrainer);
            registry.register((IForgeRegistryEntry)strainer_fisherman);
            ItemRegistry.addStrainer(strainer_fisherman, 11, Arrays.asList(ItemStrainer.StrainerType.FISHER));
        }

        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            net.initModel();
            worm.initModel();
            super_worm.initModel();
            bait_pot.initModel();
            garden_trowel.initModel();
            efficiency_meter.initModel();
            strainer_survivalist.initModel();
            strainer_survivalist_solid.initModel();
            strainer_survivalist_reinforced.initModel();
            strainer_survivalist_dense.initModel();
            strainer_survivalist_dense_solid.initModel();
            strainer_survivalist_dense_reinforced.initModel();
            strainer_fisherman.initModel();
        }
    }
}

