/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.compat;

import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import org.dave.compactmachines3.block.BlockFieldProjector;
import org.dave.compactmachines3.block.BlockMachine;
import org.dave.compactmachines3.block.BlockRedstoneTunnel;
import org.dave.compactmachines3.block.BlockTunnel;
import org.dave.compactmachines3.miniaturization.MultiblockRecipe;
import org.dave.compactmachines3.miniaturization.MultiblockRecipes;
import org.dave.compactmachines3.tile.TileEntityFieldProjector;
import org.dave.compactmachines3.tile.TileEntityMachine;
import org.dave.compactmachines3.utility.Logz;
import org.dave.compactmachines3.utility.TextFormattingHelper;

public class WailaProvider {
    public static void register(IWailaRegistrar registry) {
        Logz.info("Enabled support for Waila/Hwyla", new Object[0]);
        MachineProvider mpInstance = new MachineProvider();
        TunnelProvider tpInstance = new TunnelProvider();
        RedstoneTunnelProvider rtpInstance = new RedstoneTunnelProvider();
        FieldProvider fpInstance = new FieldProvider();
        registry.registerBodyProvider((IWailaDataProvider)mpInstance, BlockMachine.class);
        registry.registerBodyProvider((IWailaDataProvider)tpInstance, BlockTunnel.class);
        registry.registerBodyProvider((IWailaDataProvider)rtpInstance, BlockRedstoneTunnel.class);
        registry.registerBodyProvider((IWailaDataProvider)fpInstance, BlockFieldProjector.class);
        registry.registerStackProvider((IWailaDataProvider)mpInstance, BlockMachine.class);
        registry.registerStackProvider((IWailaDataProvider)tpInstance, BlockTunnel.class);
        registry.registerStackProvider((IWailaDataProvider)rtpInstance, BlockRedstoneTunnel.class);
        registry.registerStackProvider((IWailaDataProvider)fpInstance, BlockFieldProjector.class);
    }

    public static class MachineProvider
    implements IWailaDataProvider {
        public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return new ItemStack(accessor.getBlock(), 1, accessor.getMetadata());
        }

        public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            if (!(accessor.getTileEntity() instanceof TileEntityMachine)) {
                return currenttip;
            }
            String nameOrId = "";
            TileEntityMachine te = (TileEntityMachine)accessor.getTileEntity();
            nameOrId = te.coords < 0 && te.getCustomName().length() == 0 ? I18n.func_135052_a((String)"tooltip.compactmachines3.machine.coords.unused", (Object[])new Object[0]) : (te.getCustomName().length() > 0 ? te.getCustomName() : "#" + te.coords);
            currenttip.add(TextFormattingHelper.colorizeKeyValue(I18n.func_135052_a((String)"tooltip.compactmachines3.machine.coords", (Object[])new Object[0]) + " " + nameOrId));
            String sideString = I18n.func_135052_a((String)"enumfacing.side", (Object[])new Object[]{I18n.func_135052_a((String)("enumfacing." + accessor.getSide().func_176610_l()), (Object[])new Object[0])});
            currenttip.add(TextFormattingHelper.colorizeKeyValue(sideString));
            return currenttip;
        }
    }

    public static class RedstoneTunnelProvider
    implements IWailaDataProvider {
        public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            String translate = "enumfacing." + ((EnumFacing)accessor.getBlockState().func_177229_b((IProperty)BlockRedstoneTunnel.MACHINE_SIDE)).func_176610_l();
            currenttip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)translate, (Object[])new Object[0]) + TextFormatting.RESET);
            return currenttip;
        }
    }

    public static class TunnelProvider
    implements IWailaDataProvider {
        public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            String translate = "enumfacing." + ((EnumFacing)accessor.getBlockState().func_177229_b((IProperty)BlockTunnel.MACHINE_SIDE)).func_176610_l();
            currenttip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)translate, (Object[])new Object[0]) + TextFormatting.RESET);
            return currenttip;
        }
    }

    public static class FieldProvider
    implements IWailaDataProvider {
        @Nonnull
        public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            TileEntity te = accessor.getTileEntity();
            if (te instanceof TileEntityFieldProjector) {
                TileEntityFieldProjector tfp = (TileEntityFieldProjector)te;
                TileEntityFieldProjector master = tfp.getMasterProjector();
                if (master == null) {
                    return currenttip;
                }
                ItemStack crafting = master.getActiveCraftingResult();
                if (!crafting.func_190926_b()) {
                    currenttip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"top.compactmachines3.currently_crafting", (Object[])new Object[0]) + TextFormatting.RESET + " " + crafting.func_82833_r());
                    return currenttip;
                }
                MultiblockRecipe result = MultiblockRecipes.tryCrafting(accessor.getWorld(), accessor.getPosition(), null);
                if (result != null) {
                    currenttip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"top.compactmachines3.found_recipe_for", (Object[])new Object[0]) + TextFormatting.RESET + " " + result.getTargetStack().func_82833_r());
                }
            }
            return currenttip;
        }
    }
}

