/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.tileEntities.machines;

import com.mjr.extraplanets.blocks.fluid.ExtraPlanets_Fluids;
import com.mjr.extraplanets.blocks.machines.BasicPurifier;
import com.mjr.extraplanets.items.ExtraPlanets_Items;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.wrappers.FluidHandlerWrapper;
import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityBasicPurifier
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IFluidHandlerWrapper {
    private final int tankCapacity = 20000;
    private int amountDrain = 0;
    private int amountDrain2 = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank inputTank = new FluidTank(this.tankCapacity);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank inputTank2 = new FluidTank(this.tankCapacity);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank outputTank = new FluidTank(this.tankCapacity);
    public static final int PROCESS_TIME_REQUIRED = 5;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;

    public TileEntityBasicPurifier() {
        super("container.basic.purifier.name");
        this.inputTank.setFluid(new FluidStack(ExtraPlanets_Fluids.RADIO_ACTIVE_WATER_FLUID, 0));
        this.inputTank2.setFluid(new FluidStack(ExtraPlanets_Fluids.INFECTED_WATER_FLUID, 0));
        this.outputTank.setFluid(new FluidStack(ExtraPlanets_Fluids.CLEAN_WATER_FLUID, 0));
        this.inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper((IFluidHandlerWrapper)this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.checkFluidTankTransfer(1, this.inputTank);
            this.checkFluidTankTransfer(2, this.inputTank2);
            this.checkFluidTankTransfer(3, this.outputTank);
            if (this.canProcess() && this.hasEnoughEnergyToRun) {
                if (this.processTicks == 0) {
                    this.processTicks = 5;
                } else if (--this.processTicks <= 0) {
                    this.smeltItem();
                    this.processTicks = this.canProcess() ? 5 : 0;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    private void checkFluidTankTransfer(int slot, FluidTank tank) {
        ItemStack item = this.func_70301_a(slot);
        FluidStack stack = FluidUtil.getFluidContained((ItemStack)item);
        if (item != null && FluidUtil.isValidContainer((ItemStack)item)) {
            FluidStack liquid;
            if (!FluidUtil.isEmptyContainer((ItemStack)item) && stack != null && stack.getFluid() != null) {
                if (slot == 1 && stack.getFluid().equals(ExtraPlanets_Fluids.RADIO_ACTIVE_WATER_FLUID) && tank.getFluidAmount() <= tank.getCapacity()) {
                    FluidUtil.loadFromContainer((FluidTank)tank, (Fluid)ExtraPlanets_Fluids.RADIO_ACTIVE_WATER_FLUID, (NonNullList)this.getInventory(), (int)slot, (int)stack.amount);
                }
                if (slot == 2 && stack.getFluid().equals(ExtraPlanets_Fluids.INFECTED_WATER_FLUID) && tank.getFluidAmount() <= tank.getCapacity()) {
                    FluidUtil.loadFromContainer((FluidTank)tank, (Fluid)ExtraPlanets_Fluids.INFECTED_WATER_FLUID, (NonNullList)this.getInventory(), (int)slot, (int)stack.amount);
                }
            }
            if (slot == 3 && item.func_77973_b() == Items.field_151133_ar && tank.getFluidAmount() >= 1000 && item.func_190916_E() == 1 && FluidUtil.isValidContainer((ItemStack)item) && (liquid = tank.getFluid()) != null) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, (NonNullList)this.getInventory(), (int)slot, (Item)ForgeModContainer.getInstance().universalBucket);
            }
        }
    }

    public int getScaledLevelInputTank(int i) {
        return this.inputTank.getFluidAmount() * i / this.inputTank.getCapacity();
    }

    public int getScaledLevelInputTank2(int i) {
        return this.inputTank2.getFluidAmount() * i / this.inputTank2.getCapacity();
    }

    public int getScaledLevelOutputTank(int i) {
        return this.outputTank.getFluidAmount() * i / this.outputTank.getCapacity();
    }

    public boolean canProcess() {
        if (this.inputTank.getFluidAmount() <= 0 && this.inputTank2.getFluidAmount() <= 0 && this.amountDrain <= 0 & this.amountDrain2 <= 0) {
            return false;
        }
        if (this.outputTank.getFluidAmount() >= this.outputTank.getCapacity()) {
            return false;
        }
        return !this.getDisabled(0);
    }

    public boolean canPurify() {
        if (((ItemStack)this.getInventory().get(4)).func_190926_b()) {
            return false;
        }
        if (((ItemStack)this.getInventory().get(4)).func_77973_b() != ExtraPlanets_Items.IODIDE_SALT) {
            return false;
        }
        return ((ItemStack)this.getInventory().get(4)).func_190916_E() > 6;
    }

    public boolean hasInputs() {
        return (this.inputTank.getFluidAmount() >= 50 || this.inputTank2.getFluidAmount() >= 50) && !((ItemStack)this.getInventory().get(4)).func_190926_b() && ((ItemStack)this.getInventory().get(4)).func_77973_b() == ExtraPlanets_Items.IODIDE_SALT && ((ItemStack)this.getInventory().get(4)).func_190916_E() >= 6;
    }

    public void smeltItem() {
        if (this.canProcess() && this.canPurify() && this.hasInputs()) {
            int amountToDrain = 50;
            if (this.inputTank.getFluidAmount() >= 50) {
                this.inputTank.drain(50, true);
                this.amountDrain += 50;
                if (this.amountDrain >= 1000) {
                    this.inputTank2.fill(FluidRegistry.getFluidStack((String)"infected_water_fluid", (int)1000), true);
                    this.amountDrain = 0;
                    this.func_70298_a(4, 6);
                }
            }
            if (this.inputTank2.getFluidAmount() >= 50) {
                this.inputTank2.drain(50, true);
                this.amountDrain2 += 50;
                if (this.amountDrain2 >= 1000) {
                    this.outputTank.fill(FluidRegistry.getFluidStack((String)"clean_water_fluid", (int)1000), true);
                    this.amountDrain2 = 0;
                    this.func_70298_a(4, 6);
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTicks = nbt.func_74762_e("smeltingTicks");
        if (nbt.func_74764_b("inputTank")) {
            this.inputTank.readFromNBT(nbt.func_74775_l("inputTank"));
        }
        if (nbt.func_74764_b("inputTank2")) {
            this.inputTank2.readFromNBT(nbt.func_74775_l("inputTank2"));
        }
        if (nbt.func_74764_b("outputTank")) {
            this.outputTank.readFromNBT(nbt.func_74775_l("outputTank"));
        }
        if (this.inputTank.getFluid() != null && this.inputTank.getFluid().getFluid() != ExtraPlanets_Fluids.RADIO_ACTIVE_WATER_FLUID) {
            this.inputTank.setFluid(new FluidStack(ExtraPlanets_Fluids.SALT_FLUID, this.inputTank.getFluidAmount()));
        }
        if (this.inputTank2.getFluid() != null && this.inputTank2.getFluid().getFluid() != ExtraPlanets_Fluids.INFECTED_WATER_FLUID) {
            this.inputTank2.setFluid(new FluidStack(ExtraPlanets_Fluids.INFECTED_WATER_FLUID, this.inputTank2.getFluidAmount()));
        }
        if (this.outputTank.getFluid() != null && this.outputTank.getFluid().getFluid() != ExtraPlanets_Fluids.CLEAN_WATER_FLUID) {
            this.outputTank.setFluid(new FluidStack(ExtraPlanets_Fluids.CLEAN_WATER_FLUID, this.outputTank.getFluidAmount()));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        if (this.inputTank.getFluid() != null) {
            nbt.func_74782_a("inputTank", (NBTBase)this.inputTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.inputTank2.getFluid() != null) {
            nbt.func_74782_a("inputTank2", (NBTBase)this.inputTank2.writeToNBT(new NBTTagCompound()));
        }
        if (this.outputTank.getFluid() != null) {
            nbt.func_74782_a("outputTank", (NBTBase)this.outputTank.writeToNBT(new NBTTagCompound()));
        }
        return nbt;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.NORTH) {
            return new int[]{4};
        }
        return new int[]{0, 1, 2, 3, 4};
    }

    public boolean func_180462_a(int slotID, ItemStack itemStack, EnumFacing side) {
        if (itemStack != null && this.func_94041_b(slotID, itemStack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemCharged((ItemStack)itemStack);
                }
                case 4: {
                    return itemStack.func_77973_b() == ExtraPlanets_Items.IODIDE_SALT;
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_180461_b(int slotID, ItemStack itemStack, EnumFacing side) {
        if (itemStack != null && this.func_94041_b(slotID, itemStack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemEmpty((ItemStack)itemStack) || !this.shouldPullEnergy();
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        switch (slotID) {
            case 0: {
                return itemStack != null && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
            }
            case 1: 
            case 2: 
            case 3: {
                return FluidUtil.isValidContainer((ItemStack)itemStack);
            }
            case 4: {
                return itemStack.func_77973_b() == ExtraPlanets_Items.IODIDE_SALT;
            }
        }
        return false;
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    public EnumFacing getElectricInputDirection() {
        return EnumFacing.UP;
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BasicPurifier) {
            return (EnumFacing)state.func_177229_b((IProperty)BasicPurifier.FACING);
        }
        return EnumFacing.NORTH;
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (type == NetworkType.POWER) {
            return direction == this.getElectricInputDirection();
        }
        if (type == NetworkType.FLUID) {
            EnumFacing pipeSide = this.getInputPipe();
            return direction == pipeSide || direction == pipeSide.func_176734_d() || direction == EnumFacing.DOWN;
        }
        return false;
    }

    private EnumFacing getInputPipe() {
        return this.getFront().func_176746_e();
    }

    private EnumFacing getInput2Pipe() {
        return this.getFront().func_176735_f();
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        this.getFront().func_176746_e();
        if (from == EnumFacing.DOWN) {
            return this.outputTank.getFluid() != null && this.outputTank.getFluidAmount() > 0;
        }
        return false;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        this.getFront().func_176746_e();
        if (from == EnumFacing.DOWN && resource != null) {
            return this.outputTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        this.getFront().func_176746_e();
        if (from == EnumFacing.DOWN) {
            return this.drain(from, new FluidStack(ExtraPlanets_Fluids.CLEAN_WATER_FLUID, maxDrain), doDrain);
        }
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (from == this.getInputPipe()) {
            return this.inputTank.getFluid() == null || this.inputTank.getFluidAmount() < this.inputTank.getCapacity();
        }
        if (from == this.getInput2Pipe()) {
            return this.inputTank2.getFluid() == null || this.inputTank2.getFluidAmount() < this.inputTank2.getCapacity();
        }
        return false;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        String liquidName;
        int used = 0;
        if (from == this.getInputPipe() && resource != null && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null && liquidName.contains("radioactive_water")) {
            used = liquidName.equals("radioactive_water") ? this.inputTank.fill(resource, doFill) : this.inputTank.fill(new FluidStack(ExtraPlanets_Fluids.RADIO_ACTIVE_WATER_FLUID, resource.amount), doFill);
        }
        if (from == this.getInput2Pipe() && resource != null && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null && liquidName.contains("infected_water")) {
            used = liquidName.equals("infected_water") ? this.inputTank2.fill(resource, doFill) : this.inputTank2.fill(new FluidStack(ExtraPlanets_Fluids.INFECTED_WATER_FLUID, resource.amount), doFill);
        }
        return used;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (from == this.getInputPipe()) {
            return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.inputTank)};
        }
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.inputTank2)};
    }
}

