/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Saturn.worldgen;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.blocks.fluid.ExtraPlanets_Fluids;
import com.mjr.extraplanets.blocks.planetAndMoonBlocks.BlockBasicSaturn;
import com.mjr.extraplanets.planets.Saturn.worldgen.biomes.BiomeGenSaturn;
import com.mjr.extraplanets.planets.Saturn.worldgen.biomes.BiomeGenSaturnNuclearLand;
import com.mjr.extraplanets.world.features.WorldGenNuclearPile;
import com.mjr.extraplanets.world.features.WorldGenSlimeTree;
import com.mjr.mjrlegendslib.util.WorldGenUtilities;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.core.world.gen.WorldGenMinableMeta;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BiomeDecoratorSaturn
extends BiomeDecoratorSpace {
    private WorldGenerator tinGen;
    private WorldGenerator copperGen;
    private WorldGenerator ironGen;
    private WorldGenerator iceGen;
    private WorldGenerator magnesiumGen;
    private WorldGenerator gravelGen;
    private WorldGenerator slimeGen;
    private int LakesPerChunk = 5;
    private World currentWorld;
    private boolean isDecorating = false;

    public BiomeDecoratorSaturn() {
        if (Config.GENERATE_ORES_SATURN) {
            this.copperGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.SATURN_BLOCKS, 4, 5, true, ExtraPlanets_Blocks.SATURN_BLOCKS, 2);
            this.tinGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.SATURN_BLOCKS, 4, 4, true, ExtraPlanets_Blocks.SATURN_BLOCKS, 2);
            this.ironGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.SATURN_BLOCKS, 8, 3, true, ExtraPlanets_Blocks.SATURN_BLOCKS, 2);
            this.magnesiumGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.SATURN_BLOCKS, 4, 6, true, ExtraPlanets_Blocks.SATURN_BLOCKS, 2);
            this.slimeGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.SATURN_BLOCKS, 12, 12, true, ExtraPlanets_Blocks.SATURN_BLOCKS, 10);
        }
        this.iceGen = new WorldGenMinableMeta(Blocks.field_150432_aD, 18, 0, true, ExtraPlanets_Blocks.SATURN_BLOCKS, 2);
        this.gravelGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.SATURN_GRAVEL, 12, 0, true, ExtraPlanets_Blocks.SATURN_BLOCKS, 2);
    }

    protected void setCurrentWorld(World world) {
        this.currentWorld = world;
    }

    protected World getCurrentWorld() {
        return this.currentWorld;
    }

    protected void decorate() {
        int i;
        if (this.isDecorating) {
            return;
        }
        this.isDecorating = true;
        if (Config.GENERATE_ORES_SATURN) {
            this.generateOre(26, this.copperGen, 0, 60);
            this.generateOre(23, this.tinGen, 0, 60);
            this.generateOre(20, this.ironGen, 0, 64);
            this.generateOre(20, this.magnesiumGen, 0, 32);
            this.generateOre(10, this.slimeGen, 60, 256);
        }
        this.generateOre(4, this.iceGen, 50, 120);
        this.generateOre(15, this.gravelGen, 0, 80);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.currentWorld, this.rand, new BlockPos(this.posX, 0, this.posZ)));
        if (((BiomeAdaptive)this.getCurrentWorld().func_180494_b(new BlockPos(this.posX, 0, this.posZ))).isInstance(BiomeGenSaturn.class)) {
            for (i = 0; i < this.LakesPerChunk; ++i) {
                if (this.rand.nextInt(10) != 0) continue;
                WorldGenUtilities.generateLake((World)this.currentWorld, (Random)this.rand, (BlockPos)new BlockPos(this.posX, 0, this.posZ), (Block)ExtraPlanets_Fluids.GLOWSTONE, (IBlockState)ExtraPlanets_Blocks.SATURN_BLOCKS.func_176223_P().func_177226_a(BlockBasicSaturn.BASIC_TYPE, (Comparable)((Object)BlockBasicSaturn.EnumBlockBasic.SURFACE)));
            }
        }
        if (((BiomeAdaptive)this.getCurrentWorld().func_180494_b(new BlockPos(this.posX, 0, this.posZ))).isInstance(BiomeGenSaturnNuclearLand.class)) {
            for (i = 0; i < this.LakesPerChunk * 2; ++i) {
                if (this.rand.nextInt(10) != 0) continue;
                WorldGenUtilities.generateLake((World)this.currentWorld, (Random)this.rand, (BlockPos)new BlockPos(this.posX, 0, this.posZ), (Block)ExtraPlanets_Fluids.METHANE, (IBlockState)ExtraPlanets_Blocks.SATURN_BLOCKS.func_176223_P().func_177226_a(BlockBasicSaturn.BASIC_TYPE, (Comparable)((Object)BlockBasicSaturn.EnumBlockBasic.BROKEN_INFECTED_STONE)));
            }
            if (Config.GENERATE_SATURN_NUCLEAR_PILES && this.rand.nextInt(5) == 1) {
                WorldGenUtilities.generateStructure((WorldGenerator)new WorldGenNuclearPile(), (World)this.currentWorld, (Random)this.rand, (BlockPos)new BlockPos(this.posX, 0, this.posZ));
            }
            if (Config.GENERATE_SATURN_SLIME_TREES && this.rand.nextInt(5) == 1) {
                WorldGenUtilities.generateStructure((WorldGenerator)new WorldGenSlimeTree(), (World)this.currentWorld, (Random)this.rand, (BlockPos)new BlockPos(this.posX, 0, this.posZ));
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.currentWorld, this.rand, new BlockPos(this.posX, 0, this.posZ)));
        this.isDecorating = false;
    }
}

