/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.blocks.machines;

import com.google.common.base.Predicate;
import com.mjr.extraplanets.ExtraPlanets;
import com.mjr.extraplanets.tileEntities.machines.TileEntitySolar;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSolar
extends BlockTileGC
implements IShiftDescription,
IPartialSealableBlock,
ISortableBlock {
    public static final int HYBRID_METADATA = 0;
    public static final int ULTIMATE_METADATA = 4;
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<EnumSolarType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumSolarType.class);

    public BlockSolar(String name) {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149663_c(name);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> par3List) {
        par3List.add((Object)new ItemStack((Block)this, 1, 0));
        par3List.add((Object)new ItemStack((Block)this, 1, 4));
    }

    public CreativeTabs func_149708_J() {
        return ExtraPlanets.BlocksTab;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        for (int y = 1; y <= 2; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos posAt = pos.func_177982_a(y == 2 ? x : 0, y, y == 2 ? z : 0);
                    Block block = world.func_180495_p(posAt).func_177230_c();
                    if (block.func_149688_o(world.func_180495_p(pos)) == Material.field_151579_a || block.func_176200_f((IBlockAccess)world, posAt)) continue;
                    return false;
                }
            }
        }
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                BlockPos posAt = pos.func_177982_a(x, 0, z);
                Block block = world.func_180495_p(posAt).func_177230_c();
                if (block != this) continue;
                return false;
            }
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = EnumFacing.func_176731_b((int)angle).func_176734_d().func_176736_b();
        if (itemStack.func_77952_i() >= 4) {
            change += 4;
        } else if (itemStack.func_77952_i() >= 0) {
            change += 0;
        }
        world.func_180501_a(pos, this.func_176203_a(change), 3);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntitySolar) {
            ((TileEntitySolar)tile).onCreate(world, pos);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity var9 = world.func_175625_s(pos);
        if (var9 instanceof TileEntitySolar) {
            ((TileEntitySolar)var9).onDestroy(var9);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        int metadata = this.func_176201_c(world.func_180495_p(pos));
        int change = ((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING)).func_176746_e().func_176736_b();
        world.func_180501_a(pos, this.func_176203_a(metadata - metadata % 4 + change), 3);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileBaseUniversalElectrical) {
            ((TileBaseUniversalElectrical)te).updateFacing();
        }
        return true;
    }

    public boolean onMachineActivated(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        playerIn.openGui((Object)ExtraPlanets.instance, -1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public int func_180651_a(IBlockState state) {
        if (this.func_176201_c(state) >= 4) {
            return 4;
        }
        return 0;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (this.func_176201_c(state) >= 4) {
            return new TileEntitySolar(2);
        }
        return new TileEntitySolar(1);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public String getShiftDescription(int meta) {
        switch (meta) {
            case 0: {
                return TranslateUtilities.translate((String)"tile.solar_hybrid.description");
            }
            case 4: {
                return TranslateUtilities.translate((String)"tile.solar_ultimate.description");
            }
        }
        return "";
    }

    public boolean showDescription(int meta) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSealed(World world, BlockPos pos, EnumFacing direction) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(meta % 4));
        EnumSolarType type = EnumSolarType.byMetadata((int)Math.floor((double)meta / 4.0));
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a(TYPE, (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((EnumSolarType)((Object)state.func_177229_b(TYPE))).getMeta() * 4;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE});
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE;
    }

    public static enum EnumSolarType implements IStringSerializable
    {
        HYBRID_SOLAR(0, "hybrid_solar"),
        ULTIMATE_SOLAR(1, "ultimate_solar");

        private final int meta;
        private final String name;

        private EnumSolarType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumSolarType byMetadata(int meta) {
            return EnumSolarType.values()[meta];
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

