/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.blocks;

import com.mjr.extraplanets.ExtraPlanets;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.tileEntities.blocks.TileEntityPoweredChargingPadSingle;
import com.mjr.extraplanets.tileEntities.blocks.TileEntityRocketChargingPadSingle;
import com.mjr.extraplanets.tileEntities.blocks.TileEntityTier2LandingPadSingle;
import com.mjr.extraplanets.tileEntities.blocks.TileEntityTier3LandingPadSingle;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvancedTile;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCustomLandingPad
extends BlockAdvancedTile
implements IPartialSealableBlock,
IShiftDescription,
ISortableBlock {
    public static final PropertyEnum<EnumLandingPadType> PAD_TYPE = PropertyEnum.func_177709_a((String)"type", EnumLandingPadType.class);
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);

    public BlockCustomLandingPad(String name) {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c(name);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public CreativeTabs func_149708_J() {
        return ExtraPlanets.BlocksTab;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < 4; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    private boolean checkAxis(World world, BlockPos pos, Block block, EnumFacing facing) {
        int sameCount = 0;
        for (int i = 1; i <= 5; ++i) {
            if (world.func_180495_p(pos.func_177967_a(facing, i)).func_177230_c() != block) continue;
            ++sameCount;
        }
        return sameCount < 5;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        Block id = ExtraPlanets_Blocks.ADVANCED_LAUCHPAD;
        if (!(this.checkAxis(world, pos, id, EnumFacing.EAST) && this.checkAxis(world, pos, id, EnumFacing.WEST) && this.checkAxis(world, pos, id, EnumFacing.NORTH) && this.checkAxis(world, pos, id, EnumFacing.SOUTH))) {
            return false;
        }
        if (world.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c() == GCBlocks.landingPad && side == EnumFacing.UP) {
            return false;
        }
        return this.func_176196_c(world, pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileEntityTier2LandingPadSingle();
            }
            case 1: {
                return new TileEntityTier3LandingPadSingle();
            }
            case 2: {
                return new TileEntityPoweredChargingPadSingle();
            }
            case 3: {
                return new TileEntityRocketChargingPadSingle();
            }
        }
        return null;
    }

    public boolean isSealed(World world, BlockPos pos, EnumFacing direction) {
        return direction == EnumFacing.UP;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public String getShiftDescription(int meta) {
        if (meta == 0) {
            return TranslateUtilities.translate((String)(this.func_149739_a() + ".tier2.desc"));
        }
        if (meta == 1) {
            return TranslateUtilities.translate((String)(this.func_149739_a() + ".tier3.desc"));
        }
        if (meta == 2) {
            return TranslateUtilities.translate((String)(this.func_149739_a() + ".powered.desc"));
        }
        if (meta == 3) {
            return TranslateUtilities.translate((String)(this.func_149739_a() + ".powered.rocket.desc"));
        }
        return "";
    }

    public boolean showDescription(int meta) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PAD_TYPE, (Comparable)((Object)EnumLandingPadType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumLandingPadType)((Object)state.func_177229_b(PAD_TYPE))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PAD_TYPE});
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.PAD;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public static enum EnumLandingPadType implements IStringSerializable
    {
        TIER_2_ROCKET_PAD(0, "tier_2_rocket"),
        TIER_3_ROCKET_PAD(1, "tier_3_rocket"),
        POWER_CHARGING_PAD(2, "powered_charging_pad"),
        ROCKET_POWER_CHARGING_PAD(3, "rocket_powered_charging_pad");

        private final int meta;
        private final String name;

        private EnumLandingPadType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumLandingPadType byMetadata(int meta) {
            return EnumLandingPadType.values()[meta];
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

