/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.undo;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.undo.BlockHistory;
import oreexcavation.undo.RestoreResult;
import oreexcavation.utils.BigItemStack;
import oreexcavation.utils.XPHelper;

public class ExcavateHistory {
    private final List<BlockHistory> history = new ArrayList<BlockHistory>();
    private final NonNullList<BigItemStack> stacks = NonNullList.func_191196_a();
    private long experience = 0L;
    private final Stopwatch timer = Stopwatch.createUnstarted();
    private final int dimension;
    private boolean forced = false;

    public ExcavateHistory(int dimension) {
        this.dimension = dimension;
    }

    public void setForced(boolean state) {
        this.forced = state;
    }

    public BlockHistory recordPosition(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        TileEntity tile = world.func_175625_s(pos);
        NBTTagCompound tileData = null;
        if (tile != null) {
            tileData = new NBTTagCompound();
            tile.func_189515_b(tileData);
        }
        return new BlockHistory(pos, state, tileData);
    }

    public void addRecordedBlock(BlockHistory block) {
        if (this.history.contains(block) || block.state.func_177230_c() == Blocks.field_150350_a) {
            return;
        }
        this.history.add(0, block);
    }

    public void setRecievedStacks(List<BigItemStack> items) {
        this.stacks.clear();
        for (BigItemStack s : items) {
            this.stacks.add((Object)s.copy());
        }
    }

    public void setRecievedXP(long xp) {
        this.experience = xp;
    }

    public RestoreResult canRestore(MinecraftServer server, EntityPlayer player) {
        WorldServer world = server.func_71218_a(this.dimension);
        if (!player.field_71075_bZ.field_75098_d && !this.forced) {
            if (XPHelper.getPlayerXP(player) < this.experience) {
                return RestoreResult.INVALID_XP;
            }
            int[] req = new int[this.stacks.size()];
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack invoStack = player.field_71071_by.func_70301_a(i);
                if (invoStack.func_190926_b()) continue;
                for (int n = 0; n < req.length; ++n) {
                    if (!((BigItemStack)this.stacks.get(n)).equals(invoStack)) continue;
                    int n2 = n;
                    req[n2] = req[n2] + invoStack.func_190916_E();
                }
            }
            for (int n = 0; n < req.length; ++n) {
                if (req[n] >= ((BigItemStack)this.stacks.get((int)n)).stackSize) continue;
                return RestoreResult.INVALID_ITEMS;
            }
        }
        for (BlockHistory hist : this.history) {
            IBlockState state = world.func_180495_p(hist.pos);
            if (!(state.func_185904_a() != Material.field_151579_a || ExcavationSettings.undoReplace && state.func_185904_a().func_76222_j())) {
                return RestoreResult.OBSTRUCTED;
            }
            if (world.func_72839_b(null, new AxisAlignedBB((double)hist.pos.func_177958_n(), (double)hist.pos.func_177956_o(), (double)hist.pos.func_177952_p(), (double)((float)hist.pos.func_177958_n() + 1.0f), (double)((float)hist.pos.func_177956_o() + 1.0f), (double)((float)hist.pos.func_177952_p() + 1.0f))).size() <= 0) continue;
            return RestoreResult.OBSTRUCTED;
        }
        return RestoreResult.SUCCESS;
    }

    public boolean tickRestore(MinecraftServer server, EntityPlayer player) {
        this.timer.reset();
        this.timer.start();
        if (!player.field_71075_bZ.field_75098_d && this.stacks.size() > 0) {
            XPHelper.addXP(player, -this.experience, true);
            Iterator iterStacks = this.stacks.iterator();
            while (iterStacks.hasNext()) {
                BigItemStack stack = (BigItemStack)iterStacks.next();
                for (int i = 0; i < player.field_71071_by.func_70302_i_() && stack.stackSize > 0; ++i) {
                    ItemStack invoStack = player.field_71071_by.func_70301_a(i);
                    if (invoStack.func_190926_b() || !stack.equals(invoStack)) continue;
                    int num = Math.min(stack.stackSize, invoStack.func_190916_E());
                    player.field_71071_by.func_70298_a(i, num);
                    stack.stackSize -= num;
                }
                iterStacks.remove();
            }
        }
        Iterator<BlockHistory> iterator = this.history.iterator();
        WorldServer world = server.func_71218_a(this.dimension);
        while (iterator.hasNext() && (!ExcavationSettings.tpsGuard || this.timer.elapsed(TimeUnit.MILLISECONDS) <= 40L)) {
            iterator.next().restoreBlock((World)world);
            iterator.remove();
        }
        this.timer.stop();
        return this.history.size() <= 0;
    }
}

