/*
 * Decompiled with CFR 0.152.
 */
package tv.darkosto.sevpatches;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import realdrops.entities.EntityItemLoot;
import slimeknights.tconstruct.tools.ranged.RangedEvents;

@Mod(modid="sevpatches")
public class SevPatches {
    public static Logger LOGGER = LogManager.getLogger((String)"sevpatches");
    List<EntityItem> itemList = new ArrayList<EntityItem>();

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        if (event.getSide().isServer()) {
            this.registerRangedEvents();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void registerRangedEvents() {
        Optional<ModContainer> tcon = Loader.instance().getModList().stream().filter(mod -> mod.getModId().equals("tconstruct")).findAny();
        if (tcon.isPresent() && new ComparableVersion(tcon.get().getVersion()).compareTo(new ComparableVersion("1.12.2-2.13.0.183")) <= 0) {
            LOGGER.info("Tinkers' Construct detected, registering RangedEvents");
            MinecraftForge.EVENT_BUS.register(RangedEvents.class);
        } else {
            LOGGER.info("Tinkers' Construct not found or is a fixed version");
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K || event.isCanceled() || event.getEntity().field_70128_L) {
            return;
        }
        if (event.getEntity().getClass() != EntityItem.class) {
            return;
        }
        this.itemList.add((EntityItem)event.getEntity());
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        for (EntityItem item : this.itemList) {
            if (item.field_70128_L || item.func_92059_d().func_190926_b()) continue;
            item.field_70170_p.func_72838_d((Entity)new EntityItemLoot(item));
            item.func_70106_y();
            item.func_92058_a(ItemStack.field_190927_a);
        }
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        this.itemList.clear();
    }
}

