/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.config.data;

import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.config.data.EntityData;
import com.bloodnbonesgaming.triumph.config.data.InventoryData;
import com.bloodnbonesgaming.triumph.config.data.InventoryPredicate;
import com.bloodnbonesgaming.triumph.config.data.LocationPredicateExtended;
import com.bloodnbonesgaming.triumph.config.data.PlayerPredicate;
import com.bloodnbonesgaming.triumph.config.data.ScoreBoardPredicate;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.NBTPredicate;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/dataObjects/PlayerData", classExplaination="These are the functions which can be called on an PlayerData object.")
public class PlayerData
extends EntityData {
    private String gamestage = null;
    private ItemPredicate mainhand = ItemPredicate.field_192495_a;
    private ItemPredicate offhand = ItemPredicate.field_192495_a;
    private ItemPredicate feet = ItemPredicate.field_192495_a;
    private ItemPredicate legs = ItemPredicate.field_192495_a;
    private ItemPredicate chest = ItemPredicate.field_192495_a;
    private ItemPredicate head = ItemPredicate.field_192495_a;
    private InventoryData inventory = new InventoryData();
    private String UUID = null;

    @Override
    public PlayerPredicate buildPredicate() throws Exception {
        InventoryPredicate inventory = this.inventory.buildPredicate();
        DistancePredicate distance = this.distance.buildDistancePredicate();
        LocationPredicateExtended location = this.locationData.buildLocationPredicate();
        if (this.entityType == null && distance == DistancePredicate.field_193423_a && location == LocationPredicateExtended.ANY && this.scoreboard == ScoreBoardPredicate.ANY && this.name == null && this.gamestage == null && this.mainhand == ItemPredicate.field_192495_a && this.offhand == ItemPredicate.field_192495_a && this.feet == ItemPredicate.field_192495_a && this.legs == ItemPredicate.field_192495_a && this.chest == ItemPredicate.field_192495_a && this.head == ItemPredicate.field_192495_a && inventory == InventoryPredicate.ANY && this.UUID == null) {
            return PlayerPredicate.ANY;
        }
        return new PlayerPredicate(this.entityType, this.distance.buildDistancePredicate(), this.locationData.buildLocationPredicate(), MobEffectsPredicate.field_193473_a, NBTPredicate.field_193479_a, this.scoreboard, this.name, this.gamestage, this.mainhand, this.offhand, this.feet, this.legs, this.chest, this.head, this.UUID, this.inventory.buildPredicate());
    }

    @ScriptMethodDocumentation(args="String", usage="gamestage", notes="Sets the required gamestage for the player.")
    public void setGamestage(String stage) {
        this.gamestage = stage;
    }

    @ScriptMethodDocumentation(args="String, ItemBlockData", usage="slot, item", notes="Sets the required item for the provided equipment slot. Slot options are \"mainhand\", \"offhand\", \"feet\", \"legs\", \"chest\", \"head\".")
    public void setEquipmentSlot(String slot, ItemBlockData data) throws Exception {
        switch (slot.toLowerCase()) {
            case "mainhand": {
                this.mainhand = data.buildItemPredicate();
                break;
            }
            case "offhand": {
                this.offhand = data.buildItemPredicate();
                break;
            }
            case "feet": {
                this.feet = data.buildItemPredicate();
                break;
            }
            case "legs": {
                this.legs = data.buildItemPredicate();
                break;
            }
            case "chest": {
                this.chest = data.buildItemPredicate();
                break;
            }
            case "head": {
                this.head = data.buildItemPredicate();
                break;
            }
            default: {
                throw new Exception(slot + " is not an equipment slot!");
            }
        }
    }

    @ScriptMethodDocumentation(args="String", usage="slot", notes="Requires the provided slot be empty. Slot options are \"mainhand\", \"offhand\", \"feet\", \"legs\", \"chest\", \"head\".")
    public void setEquipmentSlotEmpty(String slot) throws Exception {
        switch (slot.toLowerCase()) {
            case "mainhand": {
                this.mainhand = null;
                break;
            }
            case "offhand": {
                this.offhand = null;
                break;
            }
            case "feet": {
                this.feet = null;
                break;
            }
            case "legs": {
                this.legs = null;
                break;
            }
            case "chest": {
                this.chest = null;
                break;
            }
            case "head": {
                this.head = null;
                break;
            }
            default: {
                throw new Exception(slot + " is not an equipment slot!");
            }
        }
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the InventoryData object for the player")
    public InventoryData getInventoryData() {
        return this.inventory;
    }

    @ScriptMethodDocumentation(args="String", usage="UUID", notes="Sets the required UUID for the player.")
    public void setUUID(String UUID2) {
        this.UUID = UUID2;
    }
}

