/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.display;

import betteradvancements.api.IBetterDisplayInfo;
import com.bloodnbonesgaming.triumph.advancements.display.VisibilityOption;
import com.bloodnbonesgaming.triumph.config.ConfigurationManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class ExtendedDisplayInfo
extends DisplayInfo
implements IBetterDisplayInfo {
    private final ResourceLocation advancement;
    private final int uncompletedIconColor;
    private final int completedIconColor;
    private final int uncompletedTitleColor;
    private final int completedTitleColor;
    private final Integer posX;
    private final Integer posY;
    private final Boolean drawDirectLines;
    private final int completedLineColor;
    private final int uncompletedLineColor;
    private final Boolean hideLines;
    private final List<ResourceLocation> extraConnections;
    private final List<VisibilityOption> visibilityOptions;

    public ExtendedDisplayInfo(ResourceLocation advancement, ItemStack icon, ITextComponent title, ITextComponent description, ResourceLocation background, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden, int uncompletedIconColor, int completedIconColor, int uncompletedTitleColor, int completedTitleColor, Integer posX, Integer posY, Boolean drawDirectLines, int uncompletedLineColor, int completedLineColor, Boolean hideLines, List<ResourceLocation> extraConnections, List<VisibilityOption> visibilityOptions) {
        super(icon, title, description, background, frame, showToast, announceToChat, hidden);
        this.advancement = advancement;
        this.uncompletedIconColor = uncompletedIconColor;
        this.completedIconColor = completedIconColor;
        this.uncompletedTitleColor = uncompletedTitleColor;
        this.completedTitleColor = completedTitleColor;
        this.posX = posX;
        this.posY = posY;
        this.drawDirectLines = drawDirectLines;
        this.uncompletedLineColor = uncompletedLineColor;
        this.completedLineColor = completedLineColor;
        this.extraConnections = extraConnections;
        this.hideLines = hideLines;
        this.visibilityOptions = visibilityOptions;
    }

    @Override
    public ResourceLocation getId() {
        return this.advancement;
    }

    @Override
    public int getCompletedIconColor() {
        return this.completedIconColor;
    }

    @Override
    public int getUnCompletedIconColor() {
        return this.uncompletedIconColor;
    }

    @Override
    public int getCompletedTitleColor() {
        return this.completedTitleColor;
    }

    @Override
    public int getUnCompletedTitleColor() {
        return this.uncompletedTitleColor;
    }

    @Override
    public Boolean drawDirectLines() {
        return this.drawDirectLines;
    }

    @Override
    public int getCompletedLineColor() {
        return this.completedLineColor;
    }

    @Override
    public int getUnCompletedLineColor() {
        return this.uncompletedLineColor;
    }

    @Override
    public Integer getPosX() {
        return this.posX;
    }

    @Override
    public Integer getPosY() {
        return this.posY;
    }

    @Override
    public Boolean hideLines() {
        return this.hideLines;
    }

    public List<ResourceLocation> getExtraConnections() {
        return this.extraConnections;
    }

    public List<VisibilityOption> getVisibilityOptions() {
        return this.visibilityOptions;
    }

    public List<VisibilityOption> getPageVisibilityOptions() {
        return this.visibilityOptions;
    }

    @Override
    public boolean allowDragging() {
        if (ConfigurationManager.getMainConfig() != null) {
            return ConfigurationManager.getMainConfig().allowDragging();
        }
        return false;
    }

    public void func_192290_a(PacketBuffer buf) {
        buf.func_179256_a(this.field_192300_a);
        buf.func_179256_a(this.field_193225_b);
        buf.func_150788_a(this.field_192301_b);
        buf.func_179249_a((Enum)this.field_192303_d);
        int i = 0;
        if (this.field_192302_c != null) {
            i |= 1;
        }
        if (this.field_193226_f) {
            i |= 2;
        }
        if (this.field_193228_h) {
            i |= 4;
        }
        buf.writeInt(i |= 8);
        if (this.field_192302_c != null) {
            buf.func_192572_a(this.field_192302_c);
        }
        buf.writeFloat(this.field_192304_e);
        buf.writeFloat(this.field_192305_f);
        if (this.uncompletedIconColor != -1) {
            buf.writeBoolean(true);
            buf.writeInt(this.uncompletedIconColor);
        } else {
            buf.writeBoolean(false);
        }
        if (this.completedIconColor != -1) {
            buf.writeBoolean(true);
            buf.writeInt(this.completedIconColor);
        } else {
            buf.writeBoolean(false);
        }
        if (this.uncompletedTitleColor != -1) {
            buf.writeBoolean(true);
            buf.writeInt(this.uncompletedTitleColor);
        } else {
            buf.writeBoolean(false);
        }
        if (this.completedTitleColor != -1) {
            buf.writeBoolean(true);
            buf.writeInt(this.completedTitleColor);
        } else {
            buf.writeBoolean(false);
        }
        if (this.drawDirectLines != null) {
            buf.writeBoolean(true);
            buf.writeBoolean(this.drawDirectLines.booleanValue());
        } else {
            buf.writeBoolean(false);
        }
        if (this.uncompletedLineColor != -1) {
            buf.writeBoolean(true);
            buf.writeInt(this.uncompletedLineColor);
        } else {
            buf.writeBoolean(false);
        }
        if (this.completedLineColor != -1) {
            buf.writeBoolean(true);
            buf.writeInt(this.completedLineColor);
        } else {
            buf.writeBoolean(false);
        }
        if (this.hideLines != null) {
            buf.writeBoolean(true);
            buf.writeBoolean(this.hideLines.booleanValue());
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(this.extraConnections.size());
        for (ResourceLocation location : this.extraConnections) {
            buf.func_192572_a(location);
        }
        if (this.posX != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.posX.intValue());
        } else {
            buf.writeBoolean(false);
        }
        if (this.posY != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.posY.intValue());
        } else {
            buf.writeBoolean(false);
        }
    }

    public static DisplayInfo read(PacketBuffer buf) throws IOException {
        DisplayInfo displayinfo;
        ITextComponent itextcomponent = buf.func_179258_d();
        ITextComponent itextcomponent1 = buf.func_179258_d();
        ItemStack itemstack = buf.func_150791_c();
        FrameType frametype = (FrameType)buf.func_179257_a(FrameType.class);
        int i = buf.readInt();
        ResourceLocation resourcelocation = (i & 1) != 0 ? buf.func_192575_l() : null;
        boolean flag = (i & 2) != 0;
        boolean flag1 = (i & 4) != 0;
        float posX = buf.readFloat();
        float posZ = buf.readFloat();
        if ((i & 8) != 0) {
            int uncompletedIconColor = buf.readBoolean() ? buf.readInt() : -1;
            int completedIconColor = buf.readBoolean() ? buf.readInt() : -1;
            int uncompletedTitleColor = buf.readBoolean() ? buf.readInt() : -1;
            int completedTitleColor = buf.readBoolean() ? buf.readInt() : -1;
            Boolean drawDirectLines = buf.readBoolean() ? Boolean.valueOf(buf.readBoolean()) : null;
            int uncompletedLineColor = buf.readBoolean() ? buf.readInt() : -1;
            int completedLineColor = buf.readBoolean() ? buf.readInt() : -1;
            Boolean hideLines = buf.readBoolean() ? Boolean.valueOf(buf.readBoolean()) : null;
            ArrayList<ResourceLocation> extraConnections = new ArrayList<ResourceLocation>();
            int extraConnectionsNumber = buf.readInt();
            for (int index = 0; index < extraConnectionsNumber; ++index) {
                extraConnections.add(buf.func_192575_l());
            }
            Integer x = buf.readBoolean() ? Integer.valueOf(buf.readInt()) : null;
            Integer y = buf.readBoolean() ? Integer.valueOf(buf.readInt()) : null;
            displayinfo = new ExtendedDisplayInfo(null, itemstack, itextcomponent, itextcomponent1, resourcelocation, frametype, flag, false, flag1, uncompletedIconColor, completedIconColor, uncompletedTitleColor, completedTitleColor, x, y, drawDirectLines, uncompletedLineColor, completedLineColor, hideLines, extraConnections, null);
        } else {
            displayinfo = new DisplayInfo(itemstack, itextcomponent, itextcomponent1, resourcelocation, frametype, flag, false, flag1);
        }
        displayinfo.func_192292_a(posX, posZ);
        return displayinfo;
    }
}

