/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data.triumph;

import com.bloodnbonesgaming.lib.util.data.BlockPredicate;
import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.trigger.LeftClickBlockTrigger;
import com.bloodnbonesgaming.triumph.config.data.LocationData;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.util.EnumFacing;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/triggers/triumph/left_click_block", classExplaination="These are the functions which can be called on a triumph:left_click_block criteria trigger. This criteria is triggered by a player left clicking a block.")
public class LeftClickBlockTriggerData
extends CriterionTriggerData {
    ItemPredicate itemPredicate = ItemPredicate.field_192495_a;
    BlockPredicate blockPredicate = BlockPredicate.ANY;
    private EnumFacing face = null;
    private final ItemBlockData blockData = new ItemBlockData();
    private final LocationData locationData = new LocationData();
    private final ItemBlockData itemData = new ItemBlockData();
    private final LocationData hitData = new LocationData();

    public LeftClickBlockTriggerData(String name, String advancementID) {
        super(name, advancementID);
    }

    @Override
    public Criterion buildCriterion() throws Exception {
        BlockPredicate block = this.blockPredicate == BlockPredicate.ANY ? this.blockData.buildBlockPredicate() : this.blockPredicate;
        ItemPredicate item = this.itemPredicate == ItemPredicate.field_192495_a ? this.itemData.buildItemPredicate() : this.itemPredicate;
        return new Criterion((ICriterionInstance)new LeftClickBlockTrigger.Instance(block, this.locationData.buildLocationPredicate(), item, this.face, this.hitData.buildLocationPredicate()));
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="item data", notes="Sets the required item.")
    public void setItem(ItemBlockData data) throws Exception {
        this.itemPredicate = data.buildItemPredicate();
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="block data", notes="Sets the required block.")
    public void setBlock(ItemBlockData data) throws Exception {
        this.blockPredicate = data.buildBlockPredicate();
    }

    public void setFace(String face) {
        this.face = EnumFacing.valueOf((String)face.toUpperCase());
    }

    public ItemBlockData getBlock() {
        return this.blockData;
    }

    public void setBlock(String blockName) {
        this.setBlock(blockName, null);
    }

    public void setBlock(String blockName, Integer meta) {
        this.blockData.setLocation(blockName);
        this.blockData.setMeta(meta != null ? new MinMaxBounds(Float.valueOf(meta.floatValue()), Float.valueOf(meta.floatValue())) : MinMaxBounds.field_192516_a);
    }

    public void setBlockOreDict(String oreDict) throws Exception {
        this.blockData.setOre(oreDict);
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the LocationData object so functions can be called on it.")
    public LocationData getLocationData() {
        return this.locationData;
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="biome id", notes="Sets the biome id. Can be an int or String.")
    public void setBiome(int id) {
        this.locationData.setBiome(id);
    }

    @ScriptMethodDocumentation(args="String", usage="feature id", notes="Sets the feature id. Used for things like structures.")
    public void setFeature(String feature) {
        this.locationData.setFeature(feature);
    }

    @ScriptMethodDocumentation(args="int", usage="dimension id", notes="Sets the dimension id.")
    public void setDimID(int dimID) {
        this.locationData.setDimID(dimID);
    }

    @ScriptMethodDocumentation(args="String", usage="WorldType id", notes="Sets the WorldType id.")
    public void setWorldType(String worldType) {
        this.locationData.setWorldType(worldType);
    }

    @ScriptMethodDocumentation(args="String", usage="generator string", notes="Sets the generator options string.")
    public void setGeneratorOptions(String generatorOptions) {
        this.locationData.setGeneratorOptions(generatorOptions);
    }

    public ItemBlockData getItemData() {
        return this.itemData;
    }

    public void setItem(String itemName) {
        this.setItem(itemName, null);
    }

    public void setItem(String itemName, Integer meta) {
        this.itemData.setLocation(itemName);
        this.itemData.setMeta(meta != null ? new MinMaxBounds(Float.valueOf(meta.floatValue()), Float.valueOf(meta.floatValue())) : MinMaxBounds.field_192516_a);
    }

    public ItemBlockData setItem(String itemName, Integer meta, String nbt) throws Exception {
        this.itemData.setLocation(itemName);
        this.itemData.setMeta(meta != null ? new MinMaxBounds(Float.valueOf(meta.floatValue()), Float.valueOf(meta.floatValue())) : MinMaxBounds.field_192516_a);
        this.itemData.setNBT(nbt);
        return this.itemData;
    }

    public void setItemOreDict(String oreDict) throws Exception {
        this.itemData.setOre(oreDict);
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max X coordinates for the interaction location on the block.")
    public void setHitXMinMax(float min, float max) {
        this.hitData.setXMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min X coordinate for the interaction location on the block.")
    public void setHitXMin(float min) {
        this.hitData.setXMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max X coordinate for the interaction location on the block.")
    public void setHitXMax(float max) {
        this.hitData.setXMax(max);
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max Y coordinates for the interaction location on the block.")
    public void setHitYMinMax(float min, float max) {
        this.hitData.setYMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min Y coordinate for the interaction location on the block.")
    public void setHitYMin(float min) {
        this.hitData.setYMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max Y coordinate for the interaction location on the block.")
    public void setHitYMax(float max) {
        this.hitData.setYMax(max);
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max Z coordinates for the interaction location on the block.")
    public void setHitZMinMax(float min, float max) {
        this.hitData.setZMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min Z coordinate for the interaction location on the block.")
    public void setHitZMin(float min) {
        this.hitData.setZMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max Z coordinate for the interaction location on the block.")
    public void setHitZMax(float max) {
        this.hitData.setZMax(max);
    }
}

