/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data.triumph;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Map;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.util.ResourceLocation;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/UnsupportedMods", classExplaination="When a mod has criteria which are not directly supported by Triumph, they can still be used in script advancements by calling script methods to add JSON conditions. Simply add the criteria with its Resource Location as usual, then call one of the methods listed below to add conditions to the criteria.")
public class GenericTriggerData
extends CriterionTriggerData {
    private final ResourceLocation triggerID;
    private final JsonObject conditions = new JsonObject();

    public GenericTriggerData(String criterionName, String advancementName, String triggerID) {
        super(criterionName, advancementName);
        this.triggerID = new ResourceLocation(triggerID);
    }

    @ScriptMethodDocumentation(args="String", usage="condition JSON", notes="Adds a single JSON condition to the criteria.")
    public void addCondition(String conditionJson) throws Exception {
        JsonObject obj = new JsonParser().parse("{" + conditionJson + "}").getAsJsonObject();
        for (Map.Entry entry : obj.entrySet()) {
            this.conditions.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
    }

    @ScriptMethodDocumentation(args="String", usage="condition JSON", notes="Adds multiple JSON conditions to the criteria at once.")
    public void addConditions(String conditionJson) throws Exception {
        JsonObject obj = new JsonParser().parse(conditionJson).getAsJsonObject();
        for (Map.Entry entry : obj.entrySet()) {
            this.conditions.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
    }

    @Override
    public Criterion buildCriterion() throws Exception {
        ICriterionInstance instance;
        ICriterionTrigger trigger = CriteriaTriggers.func_192119_a((ResourceLocation)this.triggerID);
        if (trigger != null && (instance = trigger.func_192166_a(this.conditions, null)) != null) {
            return new Criterion(instance);
        }
        return null;
    }
}

