/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion;

import com.bloodnbonesgaming.triumph.Triumph;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.BredAnimalsTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.BrewedPotionTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.ChangedDimensionTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.ConstructBeaconTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.ConsumeItemTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CuredZombieVillagerTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.EffectsChangedTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.EnchantedItemTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.EnterBlockTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.EntityHurtPlayerTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.EntityKilledPlayerTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.ImpossibleTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.InventoryChangeTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.ItemDurabilityTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.LevitationTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.LocationTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.NetherTravelTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.PlayerHurtEntityTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.PlayerKilledEntityTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.PlayerPlacedBlockTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.RecipeUnlockedTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.SleptInBedTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.SummonedEntityTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.TameAnimalTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.UsedTotemTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.VillagerTradeTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.botaniatweaks.FlowerGeneratedManaTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.botaniatweaks.TotalGeneratedManaTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.immersiveengineering.MultiblockFormationTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.totemic.CeremonyTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.triumph.CompletedAdvancementData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.triumph.GameStageTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.triumph.GenericTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.triumph.LeftClickBlockTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.triumph.PlayerBreakBlockTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.triumph.PlayerCraftedItemTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.triumph.PlayerDeathTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.triumph.PlayerDestroyBlockTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.triumph.PlayerHarvestBlockTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.triumph.RightClickBlockTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.triumph.RightClickItemTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.triumph.TickTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.triumph.TriumphChangedDimensionTriggerData;

public enum CriterionType {
    PLAYER_KILLED_ENTITY("minecraft:player_killed_entity"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new PlayerKilledEntityTriggerData(name, advancementID);
        }
    }
    ,
    ENTITY_KILLED_PLAYER("minecraft:entity_killed_player"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new EntityKilledPlayerTriggerData(name, advancementID);
        }
    }
    ,
    VILLAGER_TRADE("minecraft:villager_trade"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new VillagerTradeTriggerData(name, advancementID);
        }
    }
    ,
    LOCATION("minecraft:location"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new LocationTriggerData(name, advancementID);
        }
    }
    ,
    SLEPT_IN_BED("minecraft:slept_in_bed"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new SleptInBedTriggerData(name, advancementID);
        }
    }
    ,
    PLAYER_HURT_ENTITY("minecraft:player_hurt_entity"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new PlayerHurtEntityTriggerData(name, advancementID);
        }
    }
    ,
    PLAYER_CRAFT_ITEM("triumph:player_crafted_item"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new PlayerCraftedItemTriggerData(name, advancementID);
        }
    }
    ,
    INVENTORY_CHANGED("minecraft:inventory_changed"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new InventoryChangeTriggerData(name, advancementID);
        }
    }
    ,
    PLAYER_BREAK_BLOCK("triumph:player_break_block"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new PlayerBreakBlockTriggerData(name, advancementID);
        }
    }
    ,
    PLAYER_HARVEST_BLOCK("triumph:player_harvest_block"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new PlayerHarvestBlockTriggerData(name, advancementID);
        }
    }
    ,
    PLAYER_DESTROY_BLOCK("triumph:player_destroy_block"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new PlayerDestroyBlockTriggerData(name, advancementID);
        }
    }
    ,
    CHANGED_DIMENSION("minecraft:changed_dimension"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new ChangedDimensionTriggerData(name, advancementID);
        }
    }
    ,
    COMPLETED_ADVANCEMENT("triumph:completed_advancement"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new CompletedAdvancementData(name, advancementID);
        }
    }
    ,
    IMPOSSIBLE("minecraft:impossible"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new ImpossibleTriggerData(name, advancementID);
        }
    }
    ,
    RECIPE_UNLOCKED("minecraft:recipe_unlocked"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new RecipeUnlockedTriggerData(name, advancementID);
        }
    }
    ,
    TAME_ANIMAL("minecraft:tame_animal"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new TameAnimalTriggerData(name, advancementID);
        }
    }
    ,
    PLACED_BLOCK("minecraft:placed_block"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new PlayerPlacedBlockTriggerData(name, advancementID);
        }
    }
    ,
    BRED_ANIMALS("minecraft:bred_animals"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new BredAnimalsTriggerData(name, advancementID);
        }
    }
    ,
    CONSUME_ITEM("minecraft:consume_item"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new ConsumeItemTriggerData(name, advancementID);
        }
    }
    ,
    SUMMONED_ENTITY("minecraft:summoned_entity"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new SummonedEntityTriggerData(name, advancementID);
        }
    }
    ,
    ENTER_BLOCK("minecraft:enter_block"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new EnterBlockTriggerData(name, advancementID);
        }
    }
    ,
    LEVITATION("minecraft:levitation"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new LevitationTriggerData(name, advancementID);
        }
    }
    ,
    EFFECTS_CHANGED("minecraft:effects_changed"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new EffectsChangedTriggerData(name, advancementID);
        }
    }
    ,
    BREWED_POTION("minecraft:brewed_potion"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new BrewedPotionTriggerData(name, advancementID);
        }
    }
    ,
    CONSTRUCT_BEACON("minecraft:construct_beacon"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new ConstructBeaconTriggerData(name, advancementID);
        }
    }
    ,
    ITEM_DURABILITY_CHANGED("minecraft:item_durability_changed"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new ItemDurabilityTriggerData(name, advancementID);
        }
    }
    ,
    CURED_ZOMBIE_VILLAGER("minecraft:cured_zombie_villager"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new CuredZombieVillagerTriggerData(name, advancementID);
        }
    }
    ,
    ENCHANTED_ITEM("minecraft:enchanted_item"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new EnchantedItemTriggerData(name, advancementID);
        }
    }
    ,
    USED_TOTEM("minecraft:used_totem"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new UsedTotemTriggerData(name, advancementID);
        }
    }
    ,
    NETHER_TRAVEL("minecraft:nether_travel"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new NetherTravelTriggerData(name, advancementID);
        }
    }
    ,
    ENTITY_HURT_PLAYER("minecraft:entity_hurt_player"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new EntityHurtPlayerTriggerData(name, advancementID);
        }
    }
    ,
    IE_MULTIBLOCK("immersiveengineering:multiblock_formed"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            if (Triumph.immersiveEngineering) {
                return new MultiblockFormationTriggerData(name, advancementID);
            }
            Triumph.instance.getLog().info((Object)"Immersive Engineering must be installed for use of the \"immersiveengineering:multiblock_formed\" trigger type!");
            return null;
        }
    }
    ,
    LEFT_CLICK_BLOCK("triumph:left_click_block"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new LeftClickBlockTriggerData(name, advancementID);
        }
    }
    ,
    RIGHT_CLICK_BLOCK("triumph:right_click_block"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new RightClickBlockTriggerData(name, advancementID);
        }
    }
    ,
    BT_FLOWER_GENERATED_MANA("botania_tweaks:flower_generated_mana"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            if (Triumph.botaniaTweaks) {
                return new FlowerGeneratedManaTriggerData(name, advancementID);
            }
            Triumph.instance.getLog().info((Object)"BotaniaTweaks must be installed for use of the \"botania_tweaks:flower_generated_mana\" trigger type!");
            return null;
        }
    }
    ,
    BT_TOTAL_GENERATED_MANA("botania_tweaks:total_generated_mana"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            if (Triumph.botaniaTweaks) {
                return new TotalGeneratedManaTriggerData(name, advancementID);
            }
            Triumph.instance.getLog().info((Object)"BotaniaTweaks must be installed for use of the \"botania_tweaks:total_generated_mana\" trigger type!");
            return null;
        }
    }
    ,
    GAMESTAGE("triumph:gamestage"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new GameStageTriggerData(name, advancementID);
        }
    }
    ,
    CEREMONY("totemic:perform_ceremony"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            if (Triumph.totemic) {
                return new CeremonyTriggerData(name, advancementID);
            }
            Triumph.instance.getLog().info((Object)"Totemic must be installed for use of the \"totemic:perform_ceremony\" trigger type!");
            return null;
        }
    }
    ,
    RIGHT_CLICK_ITEM("triumph:right_click_item"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new RightClickItemTriggerData(name, advancementID);
        }
    }
    ,
    PLAYER_DEATH("triumph:player_death"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new PlayerDeathTriggerData(name, advancementID);
        }
    }
    ,
    TICK("triumph:tick"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new TickTriggerData(name, advancementID);
        }
    }
    ,
    TRIUMPH_CHANGED_DIMENSION("triumph:changed_dimension"){

        @Override
        public CriterionTriggerData getData(String name, String advancementID) {
            return new TriumphChangedDimensionTriggerData(name, advancementID);
        }
    };

    protected final String id;

    private CriterionType(String id) {
        this.id = !id.contains(":") ? "minecraft:" + id : id;
    }

    public abstract CriterionTriggerData getData(String var1, String var2);

    public boolean correctTrigger(String id) {
        return id.equals(this.id);
    }

    public static CriterionTriggerData getData(String id, String name, String advancementID) {
        for (CriterionType type : CriterionType.values()) {
            if (!type.correctTrigger(id)) continue;
            return type.getData(name, advancementID);
        }
        return new GenericTriggerData(name, advancementID, id);
    }
}

