/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class NBTToJsonConverter {
    private final NBTTagCompound tag;

    public NBTToJsonConverter(NBTTagCompound tag) {
        this.tag = tag;
    }

    public String convert(boolean pretty) {
        JsonObject json = NBTToJsonConverter.getObject(this.tag);
        String jsonString = json.toString();
        JsonParser parser = new JsonParser();
        GsonBuilder builder = new GsonBuilder();
        if (pretty) {
            builder.setPrettyPrinting();
        }
        Gson gson = builder.create();
        JsonElement el = parser.parse(jsonString);
        return gson.toJson(el);
    }

    public static JsonObject getObject(NBTTagCompound tag) {
        Set keys = tag.func_150296_c();
        JsonObject jsonRoot = new JsonObject();
        for (String key : keys) {
            JsonArray array;
            JsonObject keyObject = new JsonObject();
            jsonRoot.add(key, (JsonElement)keyObject);
            NBTBase nbt = tag.func_74781_a(key);
            keyObject.addProperty("type", (Number)nbt.func_74732_a());
            if (nbt instanceof NBTTagCompound) {
                keyObject.add("value", (JsonElement)NBTToJsonConverter.getObject((NBTTagCompound)nbt));
                continue;
            }
            if (nbt instanceof NBTPrimitive) {
                keyObject.addProperty("value", (Number)((NBTPrimitive)nbt).func_150286_g());
                continue;
            }
            if (nbt instanceof NBTTagString) {
                keyObject.addProperty("value", ((NBTTagString)nbt).func_150285_a_());
                continue;
            }
            if (nbt instanceof NBTTagList) {
                array = new JsonArray();
                NBTTagList tagList = (NBTTagList)nbt;
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    array.add((JsonElement)NBTToJsonConverter.getObject(tagList.func_150305_b(i)));
                }
                keyObject.add("value", (JsonElement)array);
                continue;
            }
            if (nbt instanceof NBTTagIntArray) {
                array = new JsonArray();
                NBTTagIntArray intArray = (NBTTagIntArray)nbt;
                for (int i : intArray.func_150302_c()) {
                    array.add((JsonElement)new JsonPrimitive((Number)i));
                }
                keyObject.add("value", (JsonElement)array);
                continue;
            }
            throw new IllegalArgumentException("NBT to JSON converter doesn't support the nbt tag: " + NBTBase.field_82578_b[nbt.func_74732_a()] + ", tag: " + nbt);
        }
        return jsonRoot;
    }
}

