/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.ItemAssemblyProgram;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.recipes.programs.AssemblyProgram;
import me.desht.pneumaticcraft.common.tileentity.IAssemblyMachine;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IResettable;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyDrill;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyIOUnit;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyLaser;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyPlatform;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityAssemblyController
extends TileEntityPneumaticBase
implements IAssemblyMachine,
IMinWorkingPressure {
    private static final int PROGRAM_INVENTORY_INDEX = 0;
    private static final int INVENTORY_SIZE = 1;
    private final ItemStackHandler inventory = new BaseItemStackHandler(this, 1){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || itemStack.func_77973_b() == Itemss.ASSEMBLY_PROGRAM;
        }
    };
    @DescSynced
    public final boolean[] sidesConnected = new boolean[6];
    private AssemblyProgram curProgram;
    @GuiSynced
    private boolean isMachineMissing;
    @GuiSynced
    private boolean isMachineDuplicate;
    @GuiSynced
    private AssemblyProgram.EnumMachine missingMachine;
    @GuiSynced
    private AssemblyProgram.EnumMachine duplicateMachine;
    private boolean goingToHomePosition;
    @DescSynced
    public String displayedText = "";
    @DescSynced
    public boolean hasProblem;
    private AssemblySystem assemblySystem = null;

    @Override
    public IItemHandlerModifiable getPrimaryInventory() {
        return this.inventory;
    }

    public TileEntityAssemblyController() {
        super(5.0f, 7.0f, 2000, 4);
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.SPEED);
    }

    @Override
    public void func_73660_a() {
        ItemStack programStack = this.inventory.getStackInSlot(0);
        if (this.curProgram == null && !this.goingToHomePosition && programStack.func_77973_b() == Itemss.ASSEMBLY_PROGRAM) {
            this.curProgram = ItemAssemblyProgram.getProgramFromItem(programStack.func_77960_j());
        } else if (this.curProgram != null && (programStack.func_190926_b() || this.curProgram.getClass() != ItemAssemblyProgram.getProgramFromItem(programStack.func_77960_j()).getClass())) {
            this.curProgram = null;
            if (!this.func_145831_w().field_72995_K) {
                this.goingToHomePosition = true;
            }
        }
        if (!this.func_145831_w().field_72995_K) {
            this.setStatus("Standby");
            if (this.getPressure() >= 3.5f && (this.curProgram != null || this.goingToHomePosition)) {
                if (this.assemblySystem == null) {
                    this.assemblySystem = this.findAssemblySystem();
                }
                if (!(this.assemblySystem == null || this.isMachineMissing && this.curProgram != null || this.isMachineDuplicate)) {
                    boolean useAir;
                    if (this.curProgram != null) {
                        useAir = this.curProgram.executeStep(this.assemblySystem);
                        if (useAir) {
                            this.setStatus("Running...");
                        }
                    } else {
                        useAir = true;
                        boolean resetDone = this.assemblySystem.reset();
                        this.goingToHomePosition = this.isMachineMissing || !resetDone;
                        this.setStatus("Resetting...");
                    }
                    if (useAir) {
                        this.addAir(-((int)(2.0f * this.getSpeedUsageMultiplierFromUpgrades())));
                    }
                    this.assemblySystem.setSpeed(this.getSpeedMultiplierFromUpgrades());
                }
            }
            this.hasProblem = this.isMachineMissing || this.isMachineDuplicate || this.getPressure() < 3.5f || this.curProgram == null || this.curProgram.curProblem != AssemblyProgram.EnumTubeProblem.NO_PROBLEM;
        }
        super.func_73660_a();
    }

    void invalidateAssemblySystem() {
        this.assemblySystem = null;
    }

    private AssemblySystem findAssemblySystem() {
        AssemblyProgram.EnumMachine[] requiredMachines = this.curProgram != null ? this.curProgram.getRequiredMachines() : AssemblyProgram.EnumMachine.values();
        this.duplicateMachine = null;
        AssemblySystem assemblySystem = new AssemblySystem(this);
        for (IAssemblyMachine machine : this.findMachines(requiredMachines.length * 2)) {
            if (assemblySystem.addMachine(machine)) continue;
            this.duplicateMachine = machine.getAssemblyType();
        }
        this.missingMachine = assemblySystem.checkForMissingMachine(requiredMachines);
        this.isMachineDuplicate = this.duplicateMachine != null;
        this.isMachineMissing = this.missingMachine != null;
        return assemblySystem;
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    private void setStatus(String text) {
        this.displayedText = text;
    }

    @SideOnly(value=Side.CLIENT)
    public void addProblems(List<String> problemList) {
        if (this.curProgram == null) {
            problemList.addAll(PneumaticCraftUtils.convertStringIntoList(I18n.func_135052_a((String)"gui.tab.problems.assembly_controller.no_program", (Object[])new Object[0])));
        } else if (this.isMachineDuplicate) {
            String key = I18n.func_135052_a((String)this.duplicateMachine.getTranslationKey(), (Object[])new Object[0]);
            problemList.addAll(PneumaticCraftUtils.convertStringIntoList(I18n.func_135052_a((String)"gui.tab.problems.assembly_controller.duplicateMachine", (Object[])new Object[]{key})));
        } else if (!this.isMachineMissing) {
            this.curProgram.addProgramProblem(problemList);
        } else {
            String key = I18n.func_135052_a((String)this.missingMachine.getTranslationKey(), (Object[])new Object[0]);
            problemList.addAll(PneumaticCraftUtils.convertStringIntoList(I18n.func_135052_a((String)"gui.tab.problems.assembly_controller.missingMachine", (Object[])new Object[]{key})));
        }
    }

    public List<IAssemblyMachine> findMachines(int max) {
        ArrayList<IAssemblyMachine> machineList = new ArrayList<IAssemblyMachine>();
        this.findMachines(machineList, this.func_174877_v(), max);
        return machineList;
    }

    private void findMachines(List<IAssemblyMachine> machineList, BlockPos pos, int max) {
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            TileEntity te = this.func_145831_w().func_175625_s(pos.func_177972_a(dir));
            if (!(te instanceof IAssemblyMachine) || machineList.contains(te) || machineList.size() >= max) continue;
            machineList.add((IAssemblyMachine)te);
            this.findMachines(machineList, te.func_174877_v(), max);
        }
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        this.updateConnections();
        this.invalidateAssemblySystem();
    }

    private void updateConnections() {
        List<Pair<EnumFacing, IAirHandler>> connections = this.getAirHandler(null).getConnectedPneumatics();
        Arrays.fill(this.sidesConnected, false);
        for (Pair<EnumFacing, IAirHandler> entry : connections) {
            this.sidesConnected[((EnumFacing)entry.getKey()).ordinal()] = true;
        }
    }

    @Override
    public boolean isConnectedTo(EnumFacing side) {
        return side != EnumFacing.UP;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
    }

    @Override
    public String getName() {
        return Blockss.ASSEMBLY_CONTROLLER.func_149739_a();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.goingToHomePosition = tag.func_74767_n("goingToHomePosition");
        this.displayedText = tag.func_74779_i("displayedText");
        for (int i = 0; i < 6; ++i) {
            this.sidesConnected[i] = tag.func_74767_n("sideConnected" + i);
        }
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        if (!this.inventory.getStackInSlot(0).func_190926_b()) {
            this.curProgram = ItemAssemblyProgram.getProgramFromItem(this.inventory.getStackInSlot(0).func_77960_j());
            if (this.curProgram != null) {
                this.curProgram.readFromNBT(tag);
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("goingToHomePosition", this.goingToHomePosition);
        tag.func_74778_a("displayedText", this.displayedText);
        if (this.curProgram != null) {
            this.curProgram.writeToNBT(tag);
        }
        for (int i = 0; i < 6; ++i) {
            tag.func_74757_a("sideConnected" + i, this.sidesConnected[i]);
        }
        tag.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    @Override
    public boolean isIdle() {
        return true;
    }

    @Override
    public void setSpeed(float speed) {
    }

    @Override
    public float getMinWorkingPressure() {
        return 3.5f;
    }

    @Override
    public AssemblyProgram.EnumMachine getAssemblyType() {
        return AssemblyProgram.EnumMachine.CONTROLLER;
    }

    @Override
    public void setControllerPos(BlockPos controllerPos) {
    }

    public class AssemblySystem {
        final IAssemblyMachine[] machines = new IAssemblyMachine[AssemblyProgram.EnumMachine.values().length];

        AssemblySystem(TileEntityAssemblyController controller) {
        }

        private IAssemblyMachine get(AssemblyProgram.EnumMachine machine) {
            return this.machines[machine.ordinal()];
        }

        boolean addMachine(IAssemblyMachine machine) {
            if (this.machines[machine.getAssemblyType().ordinal()] != null) {
                return false;
            }
            this.machines[machine.getAssemblyType().ordinal()] = machine;
            machine.setControllerPos(TileEntityAssemblyController.this.func_174877_v());
            return true;
        }

        boolean reset() {
            boolean resetDone = true;
            for (IAssemblyMachine machine : this.machines) {
                if (!(machine instanceof IResettable) || ((IResettable)((Object)machine)).reset()) continue;
                resetDone = false;
                if (!(machine instanceof TileEntityAssemblyPlatform)) break;
                this.getExportUnit().pickupItem(null);
                break;
            }
            return resetDone;
        }

        void setSpeed(float speedMult) {
            for (IAssemblyMachine te : this.machines) {
                if (te == null) continue;
                te.setSpeed(speedMult);
            }
        }

        TileEntityAssemblyController getController() {
            return (TileEntityAssemblyController)this.get(AssemblyProgram.EnumMachine.CONTROLLER);
        }

        public TileEntityAssemblyIOUnit getImportUnit() {
            return (TileEntityAssemblyIOUnit)this.get(AssemblyProgram.EnumMachine.IO_UNIT_IMPORT);
        }

        public TileEntityAssemblyIOUnit getExportUnit() {
            return (TileEntityAssemblyIOUnit)this.get(AssemblyProgram.EnumMachine.IO_UNIT_EXPORT);
        }

        public TileEntityAssemblyPlatform getPlatform() {
            return (TileEntityAssemblyPlatform)this.get(AssemblyProgram.EnumMachine.PLATFORM);
        }

        public TileEntityAssemblyLaser getLaser() {
            return (TileEntityAssemblyLaser)this.get(AssemblyProgram.EnumMachine.LASER);
        }

        public TileEntityAssemblyDrill getDrill() {
            return (TileEntityAssemblyDrill)this.get(AssemblyProgram.EnumMachine.DRILL);
        }

        AssemblyProgram.EnumMachine checkForMissingMachine(AssemblyProgram.EnumMachine[] requiredMachines) {
            for (AssemblyProgram.EnumMachine e : requiredMachines) {
                if (this.get(e) != null) continue;
                return e;
            }
            return null;
        }
    }
}

