/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.recipes.ExplosionCraftingRecipe;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEISpecialCraftingCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.PneumaticCraftCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.PositionedStack;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class JEIExplosionCraftingCategory
extends JEISpecialCraftingCategory<ExplosionCraftingWrapper> {
    private static IDrawable icon;

    JEIExplosionCraftingCategory(IJeiHelpers jeiHelpers) {
        super(jeiHelpers);
        icon = jeiHelpers.getGuiHelper().drawableBuilder(Textures.JEI_EXPLOSION, 0, 0, 16, 16).setTextureSize(16, 16).build();
    }

    @Override
    protected List<PneumaticCraftCategory.MultipleInputOutputRecipeWrapper> getAllRecipes() {
        ArrayList<PneumaticCraftCategory.MultipleInputOutputRecipeWrapper> recipes = new ArrayList<PneumaticCraftCategory.MultipleInputOutputRecipeWrapper>();
        for (ExplosionCraftingRecipe ecr : ExplosionCraftingRecipe.recipes) {
            ExplosionCraftingWrapper recipe = new ExplosionCraftingWrapper(ecr.getLossRate());
            NonNullList inputList = new ArrayList();
            if (!ecr.getInput().func_190926_b()) {
                inputList.add(ecr.getInput());
            } else if (ecr.getOreDictKey() != null) {
                inputList = OreDictionary.getOres((String)ecr.getOreDictKey());
            }
            if (!inputList.isEmpty()) {
                recipe.addIngredient(new PositionedStack((List<ItemStack>)inputList, 41, 1));
                recipe.addOutput(new PositionedStack(ecr.getOutput(), 105, 1));
                recipes.add(recipe);
                continue;
            }
            Log.warning("could not determine JEI input for explosion crafting recipe " + ecr.getOutput());
        }
        return recipes;
    }

    public String getUid() {
        return "pneumaticcraft.compressed_iron_explosion";
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"gui.nei.title.explosionCrafting", (Object[])new Object[0]);
    }

    @Nullable
    public IDrawable getIcon() {
        return icon;
    }

    static class ExplosionCraftingWrapper
    extends PneumaticCraftCategory.MultipleInputOutputRecipeWrapper {
        private final int lossRate;

        ExplosionCraftingWrapper(int lossRate) {
            this.lossRate = lossRate;
        }

        @Override
        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179097_i();
            GlStateManager.func_179141_d();
            icon.draw(Minecraft.func_71410_x(), 73, 0);
            GlStateManager.func_179126_j();
            GlStateManager.func_179118_c();
        }

        @Override
        @Nonnull
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            List<String> res = super.getTooltipStrings(mouseX, mouseY);
            if (mouseX >= 63 && mouseX <= 100) {
                res.addAll(PneumaticCraftUtils.convertStringIntoList(I18n.func_135052_a((String)"gui.nei.recipe.explosionCrafting", (Object[])new Object[]{this.lossRate}), 32));
            }
            return res;
        }
    }
}

